% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/format.pin.R
\name{format.pin}
\alias{format.pin}
\title{Formatting pin}
\usage{
\method{format}{pin}(x, format. = "\%Y\%m\%d\%N", ...)
}
\arguments{
\item{x}{pin vector or am vector that can be coerced to such}

\item{format.}{character string specifying the output format.
\code{\%N} is used as a reference for the last four digits of the pin.
Format of the date is handled via \code{\link{strptime}}.
(\code{"\%Y\%m\%d\%N"} by default). \code{\%P} is an available
shorthand for \code{"(\%C) \%y-\%m-\%d - \%N"}, a format aimed for
maximal readability when used in long lists}

\item{...}{further arguments passed to \code{\link{format.Date}}}
}
\value{
character vector of same length as \code{x}
}
\description{
Format \code{pin} for pretty printing
}
\examples{
x <- as.pin(fake_pins$pin[1:10])

# Separate elements with hyphens:
format(x, "\%Y-\%m-\%d-\%N")


# Separate even further
format(x, "\%C-\%y-\%m-\%d-\%N")

# The special P-format for maximal readability
format(x, "\%P")

# A custom representation
format(x, "Borned \%d of \%B in \%Y (a \%A in week \%U) with suffix no: \%N")

# Extract only the year
format(x, "\%Y")
}

