% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pVal.R
\name{pVal}
\alias{pVal}
\title{Permutation Test P-value}
\usage{
pVal(obs, null.dist)
}
\arguments{
\item{obs}{observed value.}

\item{null.dist}{vector of values from permutation null distribution.}
}
\description{
Calculate the p-value for a permutation test.
}
\examples{
null.dist <- rnorm(1000)
obs <- rnorm(1, mean = 1)

plot(density(null.dist), xlim = range(c(obs, null.dist)), main = "")
abline(v = obs)
print(obs)
pVal(obs, null.dist)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

