% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symDMatrix.R
\name{blockSize}
\alias{blockSize}
\title{Return the Block Size of a symDMatrix Object.}
\usage{
blockSize(x, last = FALSE)
}
\arguments{
\item{x}{A \linkS4class{symDMatrix} object.}

\item{last}{A boolean indicating whether to return the block size of the
last (\code{TRUE}) column/row block or any of the other blocks (\code{FALSE},
default).}
}
\value{
The block size of a \linkS4class{symDMatrix} object.
}
\description{
This function returns the block size of a \linkS4class{symDMatrix} object.
}
\details{
The last block of a column/row may be smaller than the other blocks. Its
size can be retrieved by setting \code{last} to \code{TRUE}.
}
\examples{
# Load example symDMatrix (G)
load.symDMatrix(system.file("extdata", "G.RData", package = "symDMatrix"))

# Get the block size
blockSize(G)

# Get the block size of the trailing blocks
blockSize(G, last = TRUE)
}
