% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slik.R
\name{slik}
\alias{slik}
\title{Evaluates the synthetic log-likelihood.}
\usage{
slik(object, param, nsim, multicore = FALSE, ncores = detectCores() - 1,
  cluster = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{synlik}.}

\item{param}{Vector of parameters at which the synthetic likelihood will be evaluated.}

\item{nsim}{Number of simulation from the model.}

\item{multicore}{(logical) if \code{TRUE} the \code{object@simulator} and \code{object@summaries} functions will
be executed in parallel. That is the nsim simulations will be divided in multiple cores.}

\item{ncores}{(integer) number of cores to use if \code{multicore == TRUE}.}

\item{cluster}{an object of class \code{c("SOCKcluster", "cluster")}. This allowes the user to pass her own cluster,
which will be used if \code{multicore == TRUE}. The user has to remember to stop the cluster.}

\item{...}{additional arguments to be passed to \code{object@simulator} and \code{object@summaries}.
In general I would avoid using it and including \code{object@extraArgs} everything they need.}
}
\value{
The estimated value of the synthetic log-likelihood at \code{param}.
}
\description{
Evaluates the synthetic log-likelihood.
}
\examples{
data(ricker_sl)
set.seed(643)
slik(ricker_sl, param = c(3.8, -1.2, 2.3), nsim = 500)                     
}
\author{
Matteo Fasiolo <matteo.fasiolo@gmail.com>
}
\references{
Simon N Wood. Statistical inference for noisy nonlinear ecological dynamic systems. Nature, 466(7310):1102--1104, 2010.
}

