% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.ratings.R
\name{trakt.show.ratings}
\alias{trakt.show.ratings}
\title{Get a single show's ratings}
\usage{
trakt.show.ratings(target)
}
\arguments{
\item{target}{The \code{id} of the show requested. Either the \code{slug}
(e.g. \code{"game-of-thrones"}), \code{trakt id} or \code{IMDb id}}
}
\value{
A \code{list} containing show ratings and distribution
}
\description{
\code{trakt.show.ratings} returns a single show's rating and distribution.
}
\note{
See \href{http://docs.trakt.apiary.io/reference/shows/ratings/get-show-ratings}{the trakt API docs for further info}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
trakt.show.ratings("game-of-thrones")
}
}
\seealso{
Other show data: \code{\link{trakt.get_all_episodes}};
  \code{\link{trakt.get_full_showdata}};
  \code{\link{trakt.seasons.season}};
  \code{\link{trakt.seasons.summary}};
  \code{\link{trakt.show.people}};
  \code{\link{trakt.show.summary}};
  \code{\link{trakt.show.watching}};
  \code{\link{trakt.shows.popular}};
  \code{\link{trakt.shows.related}};
  \code{\link{trakt.shows.trending}};
  \code{\link{trakt.stats}}
}

