% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.stats.R
\name{trakt.stats}
\alias{trakt.stats}
\title{[Defunct] Get a show or movie's stats}
\usage{
trakt.stats(target, type = "shows", extended = "min")
}
\arguments{
\item{target}{The \code{id} of the show/movie requested. Either the \code{slug}
(e.g. \code{"game-of-thrones"}), \code{trakt id} or \code{IMDb id}.}

\item{type}{Either \code{shows} (default) or \code{movies}, depending the \code{target} type.}

\item{extended}{Whether extended info should be provided.
Defaults to \code{"min"}, can either be \code{"min"} or \code{"full"}.}
}
\value{
A \code{list} containing show stats
}
\description{
DEFUNCT as of 2015-03-06,
see \href{http://docs.trakt.apiary.io/reference/shows/stats/get-show-stats}{their API docs}
}
\details{
\code{trakt.stats} pulls show stats and returns it compactly.
The data includes show ratings, scrobbles, checkins, plays, comments…
}
\note{
See \href{http://docs.trakt.apiary.io/#reference/shows/stats}{the trakt API docs for further info}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
breakingbad.stats <- trakt.stats(type = "shows", "breaking-bad")
}
}
\seealso{
Other movie data: \code{\link{trakt.movie.people}};
  \code{\link{trakt.movie.ratings}};
  \code{\link{trakt.movie.releases}};
  \code{\link{trakt.movie.summary}};
  \code{\link{trakt.movie.watching}};
  \code{\link{trakt.movies.popular}};
  \code{\link{trakt.movies.related}};
  \code{\link{trakt.movies.trending}}

Other show data: \code{\link{trakt.get_all_episodes}};
  \code{\link{trakt.get_full_showdata}};
  \code{\link{trakt.seasons.season}};
  \code{\link{trakt.seasons.summary}};
  \code{\link{trakt.show.people}};
  \code{\link{trakt.show.ratings}};
  \code{\link{trakt.show.summary}};
  \code{\link{trakt.show.watching}};
  \code{\link{trakt.shows.popular}};
  \code{\link{trakt.shows.related}};
  \code{\link{trakt.shows.trending}}
}

