% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabglm.R
\name{tabglm}
\alias{tabglm}
\title{Create Summary Table for Fitted Generalized Linear Model}
\usage{
tabglm(fit, columns = NULL, xvarlabels = NULL,
  factor.compression = 1, sep.char = ", ", indent.spaces = 3,
  latex = TRUE, decimals = 2, formatp.list = NULL,
  print.html = FALSE, html.filename = "table1.html")
}
\arguments{
\item{fit}{Fitted \code{\link[stats]{glm}} object.}

\item{columns}{Character vector specifying what columns to include. Choices
for each element are \code{"beta"}, \code{"se"}, \code{"betaci"} for 95\% CI
for Beta, \code{"beta.se"} for Beta (SE), \code{"beta.ci"} for Beta
(95\% CI), \code{"or"}, \code{"orci"} for 95\% CI for OR, \code{"or.ci"} for
OR (95\% CI), \code{"hr"}, \code{"hrci"} for 95\% CI for HR, \code{"hr.ci"}
for HR (95\% CI), \code{"test"} for z/t statistic, and \code{"p"}. If OR's or
HR's are requested, the function will trust that exponentiated betas
correspond to these quantities.}

\item{xvarlabels}{Named list specifying labels to use for certain predictors.
For example, if \code{fit} includes a predictor named "race"
that you want to label "Race/ethnicity" and a predictor named "age_yrs" that
you want to label "Age (years)", use
\code{xvarlabels = list(race = "Race/ethnicity", age_yrs = "Age (years)"}.}

\item{factor.compression}{Integer value from 1 to 5 controlling how much
compression is applied to factor predictors (higher value = more
compression). If 1, rows are Variable, Level 1 (ref), Level 2, ...; if 2,
rows are Variable (ref = Level 1), Level 2, ...; if 3, rows are Level 1
(ref), Level 2, ...; if 4, rows are Level 2 (ref = Level 1), ...; if 5, rows
are Level 2, ...}

\item{sep.char}{Character string with separator to place between lower and
upper bound of confidence intervals. Typically \code{"-"} or \code{", "}.}

\item{indent.spaces}{Integer value specifying how many spaces to indent
factor levels.}

\item{latex}{Logical value for whether to format table so it is
ready for printing in LaTeX via \code{\link[xtable]{xtable}} or
\code{\link[knitr]{kable}}.}

\item{decimals}{Numeric value specifying number of decimal places for numbers
other than p-values.}

\item{formatp.list}{List of arguments to pass to \code{\link[tab]{formatp}}.}

\item{print.html}{Logical value for whether to write a .html file with the
table to the current working directory.}

\item{html.filename}{Character string specifying the name of the .html file
that gets written if \code{print.html = TRUE}.}
}
\value{
Data frame which you can print in R (e.g. with \strong{xtable}'s
\code{\link[xtable]{xtable}} or \strong{knitr}'s \code{\link[knitr]{kable}})
or export to Word, Excel, or some other program. To export the table, set
\code{print.html = TRUE}. This will result in a .html file being written to
your current working directory, which you can open and copy/paste into your
document.
}
\description{
Creates a table summarizing a GLM fit using the \code{\link[stats]{glm}}
function.
}
\examples{
# Linear regression: BMI vs. age, sex, race, and treatment
fit <- glm(BMI ~ Age + Sex + Race + Group, data = tabdata)
kable(tabglm(fit))

# Can also use piping
fit \%>\% tabglm() \%>\% kable()

# Logistic regression: 1-year mortality vs. age, sex, race, and treatment
fit <- glm(death_1yr ~ Age + Sex + Race + Group, data = tabdata,
           family = binomial)
fit \%>\% tabglm() \%>\% kable()

# Same as previous, but with custom labels for Age and Race and factors
# displayed in slightly more compressed format
fit \%>\%
  tabglm(xvarlabels = list(Age = "Age (years)", Race = "Race/ethnicity"),
         factor.compression = 2) \%>\%
  kable()

# Logistic regression model with some higher-order terms
fit <- glm(death_1yr ~ poly(Age, 2, raw = TRUE) + Sex + BMI + Sex * BMI,
           data = tabdata, family = "binomial")
fit \%>\% tabglm() \%>\% kable()


}
