% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svyCreateContTable.R
\name{svyCreateContTable}
\alias{svyCreateContTable}
\title{Create an object summarizing continous variables for weighted dataset}
\usage{
svyCreateContTable(vars, strata, data, test = TRUE,
  testNormal = svyTestNormal, argsNormal = list(method = "Wald"),
  testNonNormal = svyTestNonNormal, argsNonNormal = NULL, smd = TRUE)
}
\arguments{
\item{vars}{Variable(s) to be summarized given as a character vector.}

\item{strata}{Stratifying (grouping) variable name(s) given as a character vector. If omitted, the overall results are returned.}

\item{data}{A survey design object in which these variables exist. All variables (both vars and strata) must be in this survey design object. It is created with the \code{svydesign} function in the \code{survey} package.}

\item{test}{If TRUE, as in the default and there are more than two groups, groupwise comparisons are performed. Both tests that assume normality and tests that do not are performed. Either one of the result can be obtained from the print method.}

\item{testNormal}{A function used to perform the normal assumption based tests. The default is multiple degrees of freedom test using \code{svyglm} and \code{regTermTest}. This is equivalent of the \code{svyttest} when there are only two groups.}

\item{argsNormal}{A named list of arguments passed to the function specified in \code{testNormal}.}

\item{testNonNormal}{A function used to perform the nonparametric tests. The default is \code{svyranktest}.}

\item{argsNonNormal}{A named list of arguments passed to the function specified in \code{testNonNormal}.}

\item{smd}{If TRUE, as in the default and there are more than two groups, standardized mean differences for all pairwise comparisons are calculated.}
}
\value{
An object of class \code{svyContTable}.
}
\description{
Create an object summarizing continous variables optionally stratifying by one or more startifying variables and performing statistical tests. Usually, \code{\link{svyCreateTableOne}} should be used as the universal frontend for both continuous and categorical data.
}
\examples{

## See the examples for svyCreateTableOne()

}
\seealso{
\code{\link{svyCreateTableOne}}, \code{\link{print.svyContTable}}, \code{\link{summary.svyContTable}},
}
\author{
Kazuki Yoshida
}
