% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.R
\name{tabnet_explain}
\alias{tabnet_explain}
\title{Interpretation metrics from a TabNet model}
\usage{
tabnet_explain(object, new_data)
}
\arguments{
\item{object}{a TabNet fit object}

\item{new_data}{a data.frame to obtain interpretation metrics.}
}
\value{
Returns a list with
\itemize{
\item \code{M_explain}: the aggregated feature importance masks as detailed in
TabNet's paper.
\item \code{masks} a list containing the masks for each step.
}
}
\description{
Interpretation metrics from a TabNet model
}
\examples{

if (torch::torch_is_installed()) {

set.seed(2021)

n <- 1000
x <- data.frame(
  x = runif(n),
  y = runif(n),
  z = runif(n)
)

y <- x$x

fit <- tabnet_fit(x, y, epochs = 20,
                  num_steps = 1,
                  batch_size = 512,
                  attention_width = 1,
                  num_shared = 1,
                  num_independent = 1)


 ex <- tabnet_explain(fit, x)

}

}
