% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tabplot.r
\name{plot.tabplot}
\alias{plot.tabplot}
\alias{plot.tabplot_compare}
\title{Plot a \link{tabplot-object}}
\usage{
\method{plot}{tabplot}(x, fontsize = 10, legend.lines = 8,
  max_print_levels = 15, text_NA = "missing", title = NULL,
  showTitle = NULL, fontsize.title = 14, showNumAxes = TRUE,
  rotateNames = NA, relative = FALSE, numMode = "mb-sdb-ml", vp = NULL,
  ...)

\method{plot}{tabplot_compare}(x, ...)
}
\arguments{
\item{x}{\code{\link{tabplot-object}} or \code{\link{tabplot_compare-object}}}

\item{fontsize}{the (maximum) fontsize}

\item{legend.lines}{the number of lines preserved for the legend}

\item{max_print_levels}{maximum number of printed category labels in the legend}

\item{text_NA}{text printed for the missing values category in the legend}

\item{title}{title of the plot (shown if \code{showTitle==TRUE})}

\item{showTitle}{show the title. By default \code{FALSE}, unless a \code{title} is given.}

\item{fontsize.title}{the fontsize of the title}

\item{showNumAxes}{plots an x-axis for each numerical variable, along with grid lines (\code{TRUE} by default).}

\item{rotateNames}{logical or numeric value that determines the rotation angle of the column names. If \code{TRUE}, they are rotated 90 degrees. By default, column names are rotated when the number of columns is greater than 15.}

\item{relative}{boolean that determines whether relative scales are used for relative tableplots. If \code{TRUE}, then \code{mean.diff.rel<-(mean2-mean1)/mean1*100} are used. If \code{FALSE}, then the absolute diference is taken: \code{mean <- mean2-mean}.}

\item{numMode}{character value that determines how numeric values are plotted. The value consists of the following building blocks, which are concatenated with the "-" symbol. The default value is "mb-sdb-sdl". Prior to version 1.2, "MB-ML" was the default value.
\describe{
\item{\code{sdb}}{sd bars between mean-sd to mean+sd are shown}
\item{\code{sdl}}{sd lines at mean-sd and mean+sd are shown}
\item{\code{mb}}{mean bars are shown}
\item{\code{MB}}{mean bars are shown, where the color of the bar indicate completeness where positive mean values are blue and negative orange}
\item{\code{ml}}{mean lines are shown}
\item{\code{ML}}{mean lines are shown, where positive mean values are blue and negative orange}
\item{\code{mean2}}{mean values are shown}
}}

\item{vp}{\code{\link[grid:viewport]{viewport}} to draw plot in (for instance useful to stack multiple tableplots)}

\item{...}{other arguments are not used}
}
\description{
Plot a \link{tabplot-object}. The arguments of this function, which specify the layout, can also be passed on to \code{\link{tableplot}} directly. New in version 1.2 is the argument \code{numMode}, which determines how numeric variables are plot.
}
\examples{
# load diamonds dataset from ggplot2
require(ggplot2)
data(diamonds)

tab <- tableplot(diamonds)
plot(tab, title="Shine on you Crazy Diamond!!!",
	 fontsize=12,
	 legend.lines=7,
	 fontsize.title=16)

}

