% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lp_render.R
\name{render_chordchart}
\alias{render_chordchart}
\title{Render a chord chart with LilyPond}
\usage{
render_chordchart(
  chords,
  file,
  size = 1.2,
  header = NULL,
  paper = NULL,
  colors = NULL,
  crop_png = TRUE,
  transparent = FALSE,
  res = 150,
  keep_ly = FALSE,
  details = FALSE
)
}
\arguments{
\item{chords}{named character vector of valid formatting for LilyPond chord
names and values. See examples.}

\item{file}{output file.}

\item{size}{numeric, size of fretboard diagrams (relative to paper font
size). Use this to scale diagrams up or down.}

\item{header}{a named list of arguments passed to the header of the
LilyPond file. See details.}

\item{paper}{a named list of arguments for the LilyPond file page layout.
See details.}

\item{colors}{reserved; not yet implemented for this function.}

\item{crop_png}{logical, see \code{lilypond()} for details.}

\item{transparent}{logical, transparent background, png only.}

\item{res}{numeric, resolution, png only. \code{transparent = TRUE} may fail when
\code{res} exceeds ~150.}

\item{keep_ly}{logical, keep intermediate LilyPond file.}

\item{details}{logical, set to \code{TRUE} to print LilyPond log output to
console. Windows only.}
}
\value{
writes files to disk
}
\description{
Render a standalone chord chart of chord fretboard diagrams with LilyPond
for a set of chords.
}
\details{
This function uses a generates a LilyPond template for displaying only a
fretboard diagram chart. It then passes the file to LilyPond for rendering.
To plot specific fretboard diagrams in R using ggplot and with greater
control, use \code{plot_fretboard()}.

The options for \code{paper} include the following and have the following
default values if not provided.
\itemize{
\item \code{textheight = 220}
\item \code{linewidth = 150}
\item \code{indent = 0}
\item \code{fontsize = 10}
\item \code{page_numbers = FALSE}
\item \code{print_first_page_number = TRUE}
\item \code{first_page_number = 1}
}

\code{fontsize} only controls the global font size. If you want to scale the
size of the fretboard diagrams up or down use the the \code{size} argument
rather than this \code{paper} value.

Note that chord chart output must fit on a single page. If the full set of
chord diagrams does not fit on one page then diagrams will be clipped in the
rendered output. Use \code{size} to keep the output to one page or make
multiple sheets separately.
}
\examples{
\dontrun{
suppressPackageStartupMessages(library(dplyr))

chords <- filter(
  guitarChords, root \%in\% c("c", "f") & id \%in\% c("7", "M7", "m7") &
  !grepl("#", notes) & root_fret <= 12) |>
  arrange(root, id)
chords <- setNames(chords$fretboard, chords$lp_name)
head(chords)

# requires LilyPond installation
if(tabr_options()$lilypond != ""){
  outfile <- file.path(tempdir(), "out.pdf")
  hdr <- list(
    title = "Dominant 7th, major 7th and minor 7th chords",
    subtitle = "C and F root"
  )
  render_chordchart(chords, outfile, 2, hdr, list(textheight = 175))
}
}
}
\seealso{
\code{\link[=plot_fretboard]{plot_fretboard()}}, \code{\link[=lilypond]{lilypond()}},
\code{\link[=tab]{tab()}}
}
