% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setFilter.R
\name{setFilter}
\alias{setFilter}
\title{Set filters}
\usage{
setFilter(schema = NULL, rows = NULL, columns = NULL, operator = NULL)
}
\arguments{
\item{schema}{[\code{schema(1)}]\cr In case this information is added to an
already existing schema, provide that schema here (overwrites previous
information).}

\item{rows}{[\code{integerish(.)}]\cr rows that are mentioned here are kept.}

\item{columns}{[\code{integerish(.)}]\cr columns that are mentioned here are
kept.}

\item{operator}{[\code{function(1)}]\cr \code{\link[base]{Logic}} operators
by which the current filter should be combined with the directly preceeding
filter; hence this argument is not used in case no other filter was defined
before it.}
}
\value{
An object of class \code{\link{schema}}.
}
\description{
This function allows to specify additional rules to filter certain rows
}
\examples{
(input <- tabs2shift$messy_rows)

# select rows where there is 'unit 2' in column 1 or 'year 2' in column 2
schema <-
  setFilter(rows = .find(by = "unit 2", col = 1)) \%>\%
  setFilter(rows = .find(by = "year 2", col = 2), operator = `|`) \%>\%
  setIDVar(name = "territories", columns = 1) \%>\%
  setIDVar(name = "year", columns = 2) \%>\%
  setIDVar(name = "commodities", columns = 3) \%>\%
  setObsVar(name = "harvested", columns = 5) \%>\%
  setObsVar(name = "production", columns = 6)

reorganise(schema = schema, input = input)
}
\seealso{
Other functions to describe table arrangement: 
\code{\link{setCluster}()},
\code{\link{setFormat}()},
\code{\link{setGroups}()},
\code{\link{setIDVar}()},
\code{\link{setObsVar}()}
}
\concept{functions to describe table arrangement}
