% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/date_mcd.R
\docType{methods}
\name{date_mcd}
\alias{date_mcd}
\alias{date_mcd-method}
\alias{bootstrap_mcd}
\alias{bootstrap_mcd-method}
\alias{date_mcd,CountMatrix,numeric-method}
\alias{bootstrap_mcd,CountMatrix,numeric-method}
\title{Mean Ceramic Date}
\usage{
date_mcd(object, dates, ...)

bootstrap_mcd(object, dates, ...)

\S4method{date_mcd}{CountMatrix,numeric}(object, dates, errors = NULL, ...)

\S4method{bootstrap_mcd}{CountMatrix,numeric}(object, dates, probs = c(0.05, 0.95), n = 1000)
}
\arguments{
\item{object}{A \linkS4class{CountMatrix} or a \linkS4class{DateEvent}
object.}

\item{dates}{A \code{\link{numeric}} vector of dates. If named,
the names must match the row names of \code{object}.}

\item{...}{Currently not used.}

\item{errors}{A \code{\link{numeric}} vector giving the absolute error of
\code{dates}.}

\item{probs}{A \code{\link{numeric}} vector of probabilities with values in
\eqn{[0,1]} (see \code{\link[stats:quantile]{quantile}}).}

\item{n}{A non-negative \code{\link{integer}} giving the number of bootstrap
replications.}
}
\value{
\code{date_mcd} returns a \linkS4class{DateMCD} object.

 \code{bootstrap_mcd} returns a \code{data.frame}.
}
\description{
Estimates the Mean Ceramic Date of an assemblage.
}
\details{
The Mean Ceramic Date (MCD) is a point estimate of the occupation of an
 archaeological site (South 1977). The MCD is estimated as the weighted mean
 of the date midpoints of the ceramic types (based on absolute dates or the
 known production interval) found in a given assemblage. The weights are the
 relative frequencies of the respective types in the assemblage.

 A bootstrapping procedure is used to estimate the confidence interval of a
 given MCD. For each assemblage, a large number of new bootstrap replicates
 is created, with the same sample size, by resampling the original
 assemblage with replacement. MCDs are calculated for each replicates and
 upper and lower boundaries of the confidence interval associated with each
 MCD are then returned.
}
\examples{
## Mean Ceramic Date
## Coerce the zuni dataset to an abundance (count) matrix
data("zuni", package = "folio")
counts <- as_count(zuni)

## Set the start and end dates for each ceramic type
dates <- list(
  LINO = c(600, 875), KIAT = c(850, 950), RED = c(900, 1050),
  GALL = c(1025, 1125), ESC = c(1050, 1150), PUBW = c(1050, 1150),
  RES = c(1000, 1200), TULA = c(1175, 1300), PINE = c(1275, 1350),
  PUBR = c(1000, 1200), WING = c(1100, 1200), WIPO = c(1125, 1225),
  SJ = c(1200, 1300), LSJ = c(1250, 1300), SPR = c(1250, 1300),
  PINER = c(1275, 1325), HESH = c(1275, 1450), KWAK = c(1275, 1450)
)

## Calculate date midpoints
mid <- vapply(X = dates, FUN = mean, FUN.VALUE = numeric(1))

## Calculate MCD
mc_dates <- date_mcd(counts, dates = mid)

## Bootstrap resampling
boot <- bootstrap_mcd(counts, dates = mid)
head(boot)
}
\references{
South, S. A. (1977). \emph{Method and Theory in Historical Archaeology}.
 New York: Academic Press.
}
\seealso{
Other dating: 
\code{\link{event}}
}
\author{
N. Frerebeau
}
\concept{dating}
