% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tac.R
\name{split_pvc}
\alias{split_pvc}
\title{Subset PMOD tacs with or without PVC}
\usage{
split_pvc(tac, PVC = TRUE)
}
\arguments{
\item{tac}{The time-activity curve data from loading function (PMOD)}

\item{PVC}{If TRUE, includes columns with "_C", if FALSE, ones without "_C"}
}
\value{
Time-activity curve object
}
\description{
When partial volume correction (PVC) is used in PMOD, the saved tac files
have ROIs with and without PVC. When loaded with load_tac()) it may be 
desirable to keep only either the PVC or non-PVC tacs. This returns a tac 
object that is a subset of the input tac object with only the PVC or non-PVC
tacs. This relies on PMOD's convention of labelling tac columns with "_C".
}
\examples{
# f_raw_tac and f_raw_vol are the filenames of PMOD-generated files
f_raw_tac <- system.file("extdata", "AD06.tac", package="tacmagic") 

tac <- load_tac(f_raw_tac)
tac_pvc <- split_pvc(tac, TRUE)
tac_nc <- split_pvc(tac, FALSE)
}
\seealso{
Other tac functions: \code{\link{plot.tac}},
  \code{\link{save_tac}}, \code{\link{tac_roi}}
}
\concept{tac functions}
