% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tac.R
\name{tac_roi}
\alias{tac_roi}
\title{Calculate weighted time-activity curves for specified regions of interest}
\usage{
tac_roi(tac, volumes, ROI_def, merge, PVC)
}
\arguments{
\item{tac}{The time-activity curve data from loading function}

\item{volumes}{The ROI volume data from loading function}

\item{ROI_def}{The definition of ROIs by combining smaller ROIs from TAC file}

\item{merge}{If TRUE, includes the original ROIs in the output data}

\item{PVC}{If TRUE, appends "_C" to ROI name header (as in PMOD TAC files)}
}
\value{
Time-activity curves for the specified ROIs
}
\description{
Calculate weighted time-activity curves for specified regions of interest
}
\examples{
# f_raw_tac and f_raw_vol are the filenames of PMOD-generated files
f_raw_tac <- system.file("extdata", "AD06.tac", package="tacmagic") 
f_raw_vol <- system.file("extdata", "AD06_TAC.voistat", package="tacmagic")

tac <- load_tac(f_raw_tac)
vol <- load_vol(f_raw_vol)
AD06_tac_nc <- tac_roi(tac, vol, roi_ham_full(), merge=FALSE, PVC=FALSE)
}
\seealso{
Other tac functions: \code{\link{plot.tac}},
  \code{\link{save_tac}}, \code{\link{split_pvc}}
}
\concept{tac functions}
