% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Friedman.R
\name{FRI}
\alias{FRI}
\title{Title Friedman}
\usage{
FRI(mat, id = "rate", degree = seq(0.2, 0.8, by = 0.05))
}
\arguments{
\item{mat}{matrix of the all the thermograms checked using the functiom mat.check}

\item{id}{variable choosen for subsetting mat (default = "rate")}

\item{degree}{selected degrees of  cristallinity for performing the analysis}
}
\value{
models "mod", datable "xy" for plot, "Ea" list of value, datatable "DT" built with the values of mat according to the specified degree
}
\description{
performs analysis of the thermograms using Friedman method to calculate the activation energy (Ea)
}
\examples{
 \donttest{
require(data.table)
require(MASS)
rates=c(0.5,1,2,5,10,20,50)
a<-lapply(rates, function(x) JMA(A=exp(35),Ea=120000,T0=0,T.end=300,q=x,npoints=5000,n=2))
a<-lapply(seq(1,length(a)), function(x) data.table(a[[x]]$time.s,a[[x]]$T.C,
a[[x]]$dadT, rates[[x]]))
lapply(seq(1,length(a)), function(x) setnames(a[[x]],
c("time.seconds","temperature.s","heat.flow","rates") ) )
ar<-testMat(a)
fri<-FRI(ar)
}

}
\references{
H.L. Friedman, Kinetics of thermal degradation of char-forming plastics from thermogravimetry, Appl. Phen. Plastic J. Polym. Sci. Part C: Polym. Symp. 6 (1964)
}
