% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmisc.R
\name{hmisc_data_type}
\alias{hmisc_data_type}
\title{Determine data type of a vector loosely consistent with Hmisc.}
\usage{
hmisc_data_type(x, category_threshold = NA)
}
\arguments{
\item{x}{Vector to determine type of}

\item{category_threshold}{The upper threshold of unique values for which a vector is considered categorical.}
}
\value{
One of the following strings: Binomial, Categorical, or Numerical.
}
\description{
Determine data type of a vector loosely consistent with Hmisc.
}
\examples{

hmisc_data_type(c(1,2,3))
hmisc_data_type(factor(c("A","B","C")))
hmisc_data_type(factor(c("A","B","B","A")))
hmisc_data_type(factor(c(TRUE, FALSE, TRUE, FALSE)))

}
