% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_map2_count_raw.R
\name{tar_map2_count_raw}
\alias{tar_map2_count_raw}
\title{Dynamic-within-static branching for data frames
(count batching; raw version).}
\usage{
tar_map2_count_raw(
  name,
  command1,
  command2,
  values = NULL,
  names = NULL,
  batches = 1L,
  combine = TRUE,
  suffix1 = "1",
  suffix2 = "2",
  columns1 = quote(tidyselect::everything()),
  columns2 = quote(tidyselect::everything()),
  tidy_eval = targets::tar_option_get("tidy_eval"),
  packages = targets::tar_option_get("packages"),
  library = targets::tar_option_get("library"),
  format = targets::tar_option_get("format"),
  repository = targets::tar_option_get("repository"),
  error = targets::tar_option_get("error"),
  memory = targets::tar_option_get("memory"),
  deployment = targets::tar_option_get("deployment"),
  priority = targets::tar_option_get("priority"),
  resources = targets::tar_option_get("resources"),
  storage = targets::tar_option_get("storage"),
  retrieval = targets::tar_option_get("retrieval"),
  cue = targets::tar_option_get("cue")
)
}
\arguments{
\item{name}{Character of length 1, base name of the targets.}

\item{command1}{Language object to create named arguments to \code{command2}.
Must return a data frame with one row per call to \code{command2}.}

\item{command2}{Language object  to map over the data frame of arguments
produced by \code{command1}. Must return a data frame.}

\item{values}{Named list or data frame with values to iterate over.
The names are the names of symbols in the commands and pattern
statements, and the elements are values that get substituted
in place of those symbols. Elements of the \code{values} list
should be small objects that can easily deparse to names,
such as characters, integers, and symbols.
For more complicated elements of \code{values}, such as
lists with multiple numeric vectors,
\code{tar_map()} attempts to parse the elements into expressions,
but this process is not perfect, and the default
target names come out garbled.
To create a list of symbols as a column of \code{values},
use \code{rlang::syms()}.}

\item{names}{Language object with a tidyselect expression
to select which columns of \code{values} to use to construct
statically branched target names. If \code{NULL}, then
short names are automatically generated.}

\item{batches}{Positive integer of length 1,
maximum number of batches (dynamic branches within static branches)
of the downstream (\code{command2}) targets. Batches
are formed from row groups of the \code{command1} target output.}

\item{combine}{Logical of length 1, whether to statically combine
all the results into a single target downstream.}

\item{suffix1}{Character of length 1,
suffix to apply to the \code{command1} targets to distinguish
them from the \code{command2} targets.}

\item{suffix2}{Character of length 1,
suffix to apply to the \code{command2} targets to distinguish
them from the \code{command1} targets.}

\item{columns1}{Language object, a tidyselect expression
to select which columns of \code{values}
to append to the output of all targets.}

\item{columns2}{Language object, a tidyselect expression
to select which columns of \code{command1}
output to append to \code{command2} output.
In case of conflicts, \code{column1} takes precedence.}

\item{tidy_eval}{Logical, whether to enable tidy evaluation
when interpreting \code{command} and \code{pattern}. If \code{TRUE}, you can use the
"bang-bang" operator \verb{!!} to programmatically insert
the values of global objects.}

\item{packages}{Character vector of packages to load right before
the target builds or the output data is reloaded for
downstream targets. Use \code{tar_option_set()} to set packages
globally for all subsequent targets you define.}

\item{library}{Character vector of library paths to try
when loading \code{packages}.}

\item{format}{Character of length 1, storage format of the output.
An efficient data frame format like \code{"feather"} is recommended,
but the default is \code{"rds"} to avoid incurring extra package
dependencies. See the help file of \code{targets::tar_target()}
for details on storage formats.}

\item{repository}{Character of length 1, remote repository for target
storage. Choices:
\itemize{
\item \code{"local"}: file system of the local machine.
\item \code{"aws"}: Amazon Web Services (AWS) S3 bucket. Can be configured
with a non-AWS S3 bucket using the \code{endpoint} argument of
\code{\link[targets:tar_resources_aws]{tar_resources_aws()}}, but versioning capabilities may be lost
in doing so.
See the cloud storage section of
\url{https://books.ropensci.org/targets/data.html}
for details for instructions.
\item \code{"gcp"}: Google Cloud Platform storage bucket.
See the cloud storage section of
\url{https://books.ropensci.org/targets/data.html}
for details for instructions.
}}

\item{error}{Character of length 1, what to do if the target
stops and throws an error. Options:
\itemize{
\item \code{"stop"}: the whole pipeline stops and throws an error.
\item \code{"continue"}: the whole pipeline keeps going.
\item \code{"abridge"}: any currently running targets keep running,
but no new targets launch after that.
(Visit \url{https://books.ropensci.org/targets/debugging.html}
to learn how to debug targets using saved workspaces.)
\item \code{"null"}: The errored target continues and returns \code{NULL}.
The data hash is deliberately wrong so the target is not
up to date for the next run of the pipeline.
}}

\item{memory}{Character of length 1, memory strategy.
If \code{"persistent"}, the target stays in memory
until the end of the pipeline (unless \code{storage} is \code{"worker"},
in which case \code{targets} unloads the value from memory
right after storing it in order to avoid sending
copious data over a network).
If \code{"transient"}, the target gets unloaded
after every new target completes.
Either way, the target gets automatically loaded into memory
whenever another target needs the value.
For cloud-based dynamic files such as \code{format = "aws_file"},
this memory strategy applies to
temporary local copies of the file in \verb{_targets/scratch/"}:
\code{"persistent"} means they remain until the end of the pipeline,
and \code{"transient"} means they get deleted from the file system
as soon as possible. The former conserves bandwidth,
and the latter conserves local storage.}

\item{deployment}{Character of length 1, only relevant to
\code{\link[targets:tar_make_clustermq]{tar_make_clustermq()}} and \code{\link[targets:tar_make_future]{tar_make_future()}}. If \code{"worker"},
the target builds on a parallel worker. If \code{"main"},
the target builds on the host machine / process managing the pipeline.}

\item{priority}{Numeric of length 1 between 0 and 1. Controls which
targets get deployed first when multiple competing targets are ready
simultaneously. Targets with priorities closer to 1 get built earlier
(and polled earlier in \code{\link[targets:tar_make_future]{tar_make_future()}}).}

\item{resources}{Object returned by \code{tar_resources()}
with optional settings for high-performance computing
functionality, alternative data storage formats,
and other optional capabilities of \code{targets}.
See \code{tar_resources()} for details.}

\item{storage}{Character of length 1, only relevant to
\code{\link[targets:tar_make_clustermq]{tar_make_clustermq()}} and \code{\link[targets:tar_make_future]{tar_make_future()}}.
Must be one of the following values:
\itemize{
\item \code{"main"}: the target's return value is sent back to the
host machine and saved/uploaded locally.
\item \code{"worker"}: the worker saves/uploads the value.
\item \code{"none"}: almost never recommended. It is only for
niche situations, e.g. the data needs to be loaded
explicitly from another language. If you do use it,
then the return value of the target is totally ignored
when the target ends, but
each downstream target still attempts to load the data file
(except when \code{retrieval = "none"}).

If you select \code{storage = "none"}, then
the return value of the target's command is ignored,
and the data is not saved automatically.
As with dynamic files (\code{format = "file"} or \code{"aws_file"}) it is the
responsibility of the user to write to
\code{\link[targets:tar_path]{tar_path()}} from inside the target.
An example target
could look something like
tar_target(x,
{saveRDS("value", tar_path(create_dir = TRUE)); "ignored"},
storage = "none")`.

The distinguishing feature of \code{storage = "none"}
(as opposed to \code{format = "file"} or \code{"aws_file"})
is that in the general case,
downstream targets will automatically try to load the data
from the data store as a dependency. As a corollary, \code{storage = "none"}
is completely unnecessary if \code{format} is \code{"file"} or \code{"aws_file"}.
}}

\item{retrieval}{Character of length 1, only relevant to
\code{\link[targets:tar_make_clustermq]{tar_make_clustermq()}} and \code{\link[targets:tar_make_future]{tar_make_future()}}.
Must be one of the following values:
\itemize{
\item \code{"main"}: the target's dependencies are loaded on the host machine
and sent to the worker before the target builds.
\item \code{"worker"}: the worker loads the targets dependencies.
\item \code{"none"}: the dependencies are not loaded at all.
This choice is almost never recommended. It is only for
niche situations, e.g. the data needs to be loaded
explicitly from another language.
}}

\item{cue}{An optional object from \code{tar_cue()} to customize the
rules that decide whether the target is up to date.}
}
\value{
A list of new target objects.
See the "Target objects" section for background.
}
\description{
Define targets for batched
dynamic-within-static branching for data frames,
where the user sets the (maximum) number of batches.
Like \code{tar_map2_count()} except \code{name} is a character string
and \code{command1}, \code{command2}, \code{names}, \code{columns1}, and \code{columns2}
are all language objects.
}
\details{
Static branching creates one pair of targets
for each row in \code{values}. In each pair,
there is an upstream non-dynamic target that runs \code{command1}
and a downstream dynamic target that runs \code{command2}.
\code{command1} produces a data frame of arguments to
\code{command2}, and \code{command2} dynamically maps over
these arguments in batches.
}
\section{Target objects}{

Most \code{tarchetypes} functions are target factories,
which means they return target objects
or lists of target objects.
Target objects represent skippable steps of the analysis pipeline
as described at \url{https://books.ropensci.org/targets/}.
Please read the walkthrough at
\url{https://books.ropensci.org/targets/walkthrough.html}
to understand the role of target objects in analysis pipelines.

For developers,
\url{https://wlandau.github.io/targetopia/contributing.html#target-factories}
explains target factories (functions like this one which generate targets)
and the design specification at
\url{https://books.ropensci.org/targets-design/}
details the structure and composition of target objects.
}

\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
targets::tar_dir({ # tar_dir() runs code from a temporary directory.
targets::tar_script({
  tarchetypes::tar_map2_count_raw(
    "x",
    command1 = quote(
      tibble::tibble(
        arg1 = arg1,
        arg2 = seq_len(6)
       )
    ),
    command2 = quote(
      tibble::tibble(
        result = paste(arg1, arg2),
        random = sample.int(1e6, size = 1),
        length_input = length(arg1)
      )
    ),
    values = tibble::tibble(arg1 = letters[seq_len(2)]),
    batches = 3
   )
})
targets::tar_make()
targets::tar_read(x)
})
}
}
\seealso{
Other branching: 
\code{\link{tar_combine_raw}()},
\code{\link{tar_combine}()},
\code{\link{tar_map2_count}()},
\code{\link{tar_map2_raw}()},
\code{\link{tar_map2_size_raw}()},
\code{\link{tar_map2_size}()},
\code{\link{tar_map2}()},
\code{\link{tar_map_rep_raw}()},
\code{\link{tar_map_rep}()},
\code{\link{tar_map}()},
\code{\link{tar_rep2_raw}()},
\code{\link{tar_rep2}()},
\code{\link{tar_rep_map_raw}()},
\code{\link{tar_rep_map}()},
\code{\link{tar_rep_raw}()},
\code{\link{tar_rep}()}
}
\concept{branching}
