% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_render_rep_raw.R
\name{tar_render_rep_raw}
\alias{tar_render_rep_raw}
\title{Parameterized R Markdown with dynamic branching (raw version).}
\usage{
tar_render_rep_raw(
  name,
  path,
  params = expression(NULL),
  batches = NULL,
  packages = targets::tar_option_get("packages"),
  library = targets::tar_option_get("library"),
  format = targets::tar_option_get("format"),
  iteration = targets::tar_option_get("iteration"),
  error = targets::tar_option_get("error"),
  memory = targets::tar_option_get("memory"),
  garbage_collection = targets::tar_option_get("garbage_collection"),
  deployment = targets::tar_option_get("deployment"),
  priority = targets::tar_option_get("priority"),
  resources = targets::tar_option_get("resources"),
  retrieval = targets::tar_option_get("retrieval"),
  cue = targets::tar_option_get("cue"),
  quiet = TRUE,
  args = list()
)
}
\arguments{
\item{name}{Symbol, name of the target. A target
name must be a valid name for a symbol in R, and it
must not start with a dot. Subsequent targets
can refer to this name symbolically to induce a dependency relationship:
e.g. \code{tar_target(downstream_target, f(upstream_target))} is a
target named \code{downstream_target} which depends on a target
\code{upstream_target} and a function \code{f()}. In addition, a target's
name determines its random number generator seed. In this way,
each target runs with a reproducible seed so someone else
running the same pipeline should get the same results,
and no two targets in the same pipeline share the same seed.
(Even dynamic branches have different names and thus different seeds.)
You can recover the seed of a completed target
with \code{tar_meta(your_target, seed)} and run \code{set.seed()} on the result
to locally recreate the target's initial RNG state.}

\item{path}{Character string, file path to the R Markdown source file.
Must have length 1.}

\item{params}{Expression object with code to generate
a data frame or \code{tibble} with one row per rendered report
and one column per R Markdown parameter. You may also include an
\code{output_file} column to specify the path of each rendered report.
R Markdown parameters must not be named \code{tar_group} or \code{output_file}.
This \code{params} argument is converted into the command for a target
that supplies the R Markdown parameters.}

\item{batches}{Number of batches to group the R Markdown files.
For a large number of reports, increase the number of batches
to decrease target-level overhead. Defaults to the number of
reports to render (1 report per batch).}

\item{packages}{Character vector of packages to load right before
the target builds or the output data is reloaded for
downstream targets. Use \code{tar_option_set()} to set packages
globally for all subsequent targets you define.}

\item{library}{Character vector of library paths to try
when loading \code{packages}.}

\item{format}{Character of length 1, \code{format} argument to \code{tar_target()}
to store the data frame of R Markdown parameters.}

\item{iteration}{Character of length 1, \code{iteration} argument
to \code{tar_target()} for the R Markdown documents. Does not apply
to the target with R Markdown parameters (whose iteration
is always \code{"group"}).}

\item{error}{Character of length 1, what to do if the target
stops and throws an error. Options:
\itemize{
\item \code{"stop"}: the whole pipeline stops and throws an error.
\item \code{"continue"}: the whole pipeline keeps going.
\item \code{"abridge"}: any currently running targets keep running,
but no new targets launch after that.
(Visit \url{https://books.ropensci.org/targets/debugging.html}
to learn how to debug targets using saved workspaces.)
\item \code{"null"}: The errored target continues and returns \code{NULL}.
The data hash is deliberately wrong so the target is not
up to date for the next run of the pipeline.
}}

\item{memory}{Character of length 1, memory strategy.
If \code{"persistent"}, the target stays in memory
until the end of the pipeline (unless \code{storage} is \code{"worker"},
in which case \code{targets} unloads the value from memory
right after storing it in order to avoid sending
copious data over a network).
If \code{"transient"}, the target gets unloaded
after every new target completes.
Either way, the target gets automatically loaded into memory
whenever another target needs the value.
For cloud-based dynamic files
(e.g. \code{format = "file"} with \code{repository = "aws"}),
this memory strategy applies to the
temporary local copy of the file:
\code{"persistent"} means it remains until the end of the pipeline
and is then deleted,
and \code{"transient"} means it gets deleted as soon as possible.
The former conserves bandwidth,
and the latter conserves local storage.}

\item{garbage_collection}{Logical, whether to run \code{base::gc()}
just before the target runs.}

\item{deployment}{Character of length 1, only relevant to
\code{\link[targets:tar_make_clustermq]{tar_make_clustermq()}} and \code{\link[targets:tar_make_future]{tar_make_future()}}. If \code{"worker"},
the target builds on a parallel worker. If \code{"main"},
the target builds on the host machine / process managing the pipeline.}

\item{priority}{Numeric of length 1 between 0 and 1. Controls which
targets get deployed first when multiple competing targets are ready
simultaneously. Targets with priorities closer to 1 get built earlier
(and polled earlier in \code{\link[targets:tar_make_future]{tar_make_future()}}).}

\item{resources}{Object returned by \code{tar_resources()}
with optional settings for high-performance computing
functionality, alternative data storage formats,
and other optional capabilities of \code{targets}.
See \code{tar_resources()} for details.}

\item{retrieval}{Character of length 1, only relevant to
\code{\link[targets:tar_make_clustermq]{tar_make_clustermq()}} and \code{\link[targets:tar_make_future]{tar_make_future()}}.
Must be one of the following values:
\itemize{
\item \code{"main"}: the target's dependencies are loaded on the host machine
and sent to the worker before the target builds.
\item \code{"worker"}: the worker loads the targets dependencies.
\item \code{"none"}: the dependencies are not loaded at all.
This choice is almost never recommended. It is only for
niche situations, e.g. the data needs to be loaded
explicitly from another language.
}}

\item{cue}{An optional object from \code{tar_cue()} to customize the
rules that decide whether the target is up to date.}

\item{quiet}{An option to suppress printing during rendering from knitr,
pandoc command line and others. To only suppress printing of the last
"Output created: " message, you can set \code{rmarkdown.render.message} to
\code{FALSE}}

\item{args}{Named list of other arguments to \code{rmarkdown::render()}.
Must not include \code{params} or \code{output_file}. Evaluated when the target
is defined.}
}
\value{
A list of target objects to render the R Markdown
reports. Changes to the parameters, source file, dependencies, etc.
will cause the appropriate targets to rerun during \code{tar_make()}.
See the "Target objects" section for background.
}
\description{
Targets to render a parameterized R Markdown report
with multiple sets of parameters (raw version). Same as
\code{tar_render_rep()} except \code{name} is a character string,
\code{params} is an expression object,
and extra arguments to \code{rmarkdown::render()} are passed through
the \code{args} argument instead of \code{...}.
}
\details{
\code{tar_render_rep_raw()} is an alternative to \code{tar_target_raw()} for
parameterized R Markdown reports that depend on other targets.
Parameters must be given as a data frame with one row per
rendered report and one column per parameter. An optional
\code{output_file} column may be included to set the output file path
of each rendered report.
The R Markdown source should mention other dependency targets
\code{tar_load()} and \code{tar_read()} in the active code chunks
(which also allows you to render the report
outside the pipeline if the \verb{_targets/} data store already exists
and appropriate defaults are specified for the parameters).
(Do not use \code{tar_load_raw()} or \code{tar_read_raw()} for this.)
Then, \code{tar_render()} defines a special kind of target. It
1. Finds all the \code{tar_load()}/\code{tar_read()} dependencies in the report
and inserts them into the target's command.
This enforces the proper dependency relationships.
(Do not use \code{tar_load_raw()} or \code{tar_read_raw()} for this.)
2. Sets \code{format = "file"} (see \code{tar_target()}) so \code{targets}
watches the files at the returned paths and reruns the report
if those files change.
3. Configures the target's command to return the output
report files: the rendered document, the source file,
and then the \verb{*_files/} directory if it exists.
All these file paths
are relative paths so the project stays portable.
4. Forces the report to run in the user's current working directory
instead of the working directory of the report.
5. Sets convenient default options such as \code{deployment = "main"}
in the target and \code{quiet = TRUE} in \code{rmarkdown::render()}.
}
\section{Target objects}{

Most \code{tarchetypes} functions are target factories,
which means they return target objects
or lists of target objects.
Target objects represent skippable steps of the analysis pipeline
as described at \url{https://books.ropensci.org/targets/}.
Please read the walkthrough at
\url{https://books.ropensci.org/targets/walkthrough.html}
to understand the role of target objects in analysis pipelines.

For developers,
\url{https://wlandau.github.io/targetopia/contributing.html#target-factories}
explains target factories (functions like this one which generate targets)
and the design specification at
\url{https://books.ropensci.org/targets-design/}
details the structure and composition of target objects.
}

\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
targets::tar_dir({ # tar_dir() runs code from a temporary directory.
# Parameterized R Markdown:
lines <- c(
  "---",
  "title: 'report.Rmd source file'",
  "output_format: html_document",
  "params:",
  "  par: \"default value\"",
  "---",
  "Assume these lines are in a file called report.Rmd.",
  "```{r}",
  "print(params$par)",
  "```"
)
# The following pipeline will run the report for each row of params.
targets::tar_script({
  library(tarchetypes)
  list(
    tar_render_rep_raw(
      "report",
      "report.Rmd",
      params = quote(tibble::tibble(par = c(1, 2)))
    )
  )
}, ask = FALSE)
# Then, run the targets pipeline as usual.
})
}
}
\seealso{
Other Literate programming targets: 
\code{\link{tar_knit_raw}()},
\code{\link{tar_knit}()},
\code{\link{tar_quarto_raw}()},
\code{\link{tar_quarto_rep_raw}()},
\code{\link{tar_quarto_rep}()},
\code{\link{tar_quarto}()},
\code{\link{tar_render_raw}()},
\code{\link{tar_render_rep}()},
\code{\link{tar_render}()}
}
\concept{Literate programming targets}
