% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_destroy.R
\name{tar_destroy}
\alias{tar_destroy}
\title{Destroy all or part of the data store.}
\usage{
tar_destroy(
  destroy = c("all", "meta", "process", "progress", "objects", "scratch", "workspaces"),
  ask = NULL,
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{destroy}{Character of length 1, what to destroy. Choices:
\itemize{
\item \code{"all"}: destroy the entire data store (default: \verb{_targets/})
\item \code{"meta"}: just delete the metadata file at \code{meta/meta} in the
data store, which invalidates all the targets but keeps the data.
\item \code{"process"}: just delete the progress data file at
\code{meta/process} in the data store, which resets the metadata
of the main process.
\item \code{"progress"}: just delete the progress data file at
\code{meta/progress} in the data store,
which resets the progress tracking info.
\item \code{"objects"}: delete all the target
return values in \verb{objects/} in the data
store but keep progress and metadata.
Dynamic files are not deleted this way.
\item \code{"scratch"}: temporary files saved during \code{\link[=tar_make]{tar_make()}} that should
automatically get deleted except if R crashed.
\item \code{"workspaces"}: compressed files in \verb{workspaces/} in the data store with
the saved workspaces of targets. See \code{\link[=tar_workspace]{tar_workspace()}} for details.
}}

\item{ask}{Logical of length 1, whether to pause with a menu prompt
before deleting files. To disable this menu, set the \code{TAR_ASK}
environment variable to \code{"false"}. \code{usethis::edit_r_environ()}
can help set environment variables.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
Nothing.
}
\description{
Destroy all or part of the data store written
by \code{\link[=tar_make]{tar_make()}} and similar functions.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script(list(tar_target(x, 1 + 1)), ask = FALSE)
tar_make() # Creates the _targets/ data store.
tar_destroy()
print(file.exists("_targets")) # Should be FALSE.
})
}
}
\seealso{
Other clean: 
\code{\link{tar_delete}()},
\code{\link{tar_invalidate}()},
\code{\link{tar_prune}()}
}
\concept{clean}
