% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_unblock_process.R
\name{tar_unblock_process}
\alias{tar_unblock_process}
\title{Unblock the pipeline process}
\usage{
tar_unblock_process(store = targets::tar_config_get("store"))
}
\arguments{
\item{store}{Character string, path to the data store
(usually \code{"_targets"}).}
}
\value{
\code{NULL} (invisibly). Called for its side effects.
}
\description{
\code{targets} tries to avoid running two concurrent instances
of \code{\link[=tar_make]{tar_make()}} on the same pipeline writing to the same data store.
Sometimes it generates false positives (meaning \code{\link[=tar_make]{tar_make()}} throws
this error even though there is only one instance of the pipeline
running.) If there is a false positive, \code{\link[=tar_unblock_process]{tar_unblock_process()}}
gets the pipeline unstuck by removing the \verb{_targets/meta/process} file.
This allows the next call to \code{\link[=tar_make]{tar_make()}} to resume.
}
\seealso{
Other utilities: 
\code{\link{tar_active}()},
\code{\link{tar_backoff}()},
\code{\link{tar_call}()},
\code{\link{tar_cancel}()},
\code{\link{tar_definition}()},
\code{\link{tar_described_as}()},
\code{\link{tar_envir}()},
\code{\link{tar_format_get}()},
\code{\link{tar_group}()},
\code{\link{tar_name}()},
\code{\link{tar_path}()},
\code{\link{tar_path_script}()},
\code{\link{tar_path_script_support}()},
\code{\link{tar_path_store}()},
\code{\link{tar_path_target}()},
\code{\link{tar_source}()},
\code{\link{tar_store}()}
}
\concept{utilities}
