% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_workbook.R, R/save_xlsx.R
\name{as_workbook}
\alias{as_workbook}
\alias{as_workbook.default}
\alias{as_workbook.Tatoo_report}
\alias{save_xlsx}
\title{Convert a Tatto table object to an Excel workbook}
\usage{
as_workbook(dat, sheet = 1L, ...)

\method{as_workbook}{default}(dat, sheet = 1L, ...)

\method{as_workbook}{Tatoo_report}(dat, ...)

save_xlsx(dat, outfile, overwrite = FALSE, ...)
}
\arguments{
\item{dat}{a \link{Tatoo_table} or \link{Tatoo_report}}

\item{sheet}{The worksheet to write to. Can be the worksheet index or name.}

\item{...}{passed on to \code{\link[=write_worksheet]{write_worksheet()}}}

\item{outfile}{path/name of the output file}

\item{overwrite}{logical. If \code{TRUE}, overwrite any existing file.}
}
\value{
an openxlsx \link{openxlsx} Workbook object (invisibly for \code{save.xlsx})

TRUE on success
}
\description{
This function converts Tatoo_table obects directly to \link{openxlsx} Workbook
objects. For information about additional parameters please refer to the
documentation of \code{write_worksheet()}, for which \code{as_workbook()}
is just a wraper. Additional possible function arguments way vary depending
on depending which Tatoo_table you want to export.

Converting a \code{Tatoo_report} will result in a \code{Workbook} with
several sheets. The sheet names will be generated from the names of
\code{dat} (if \code{dat} has names).

\code{save_xlsx} is a shortcut to save a Tatoo_table direclty to local .xlsx
file.
}
\examples{
\dontrun{
dat <- data.frame(
  Species = c("setosa", "versicolor", "virginica"),
  length = c(5.01, 5.94, 6.59),
  width = c(3.43, 2.77, 2.97)
)

# Assign metadata to convert dat to a Tagged_table

title(dat) <- 'Iris excerpt'
footer(dat) <-  'An example based on the iris dataset'


# Convert to Workbook or save als xlsx

wb <- as_workbook(dat)
save_xlsx(dat, 'iris.xlsx', overwrite = TRUE)
}

}
\seealso{
Other xlsx exporters: \code{\link{write_worksheet}}
}
