% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/phylomatic_format.R
\name{phylomatic_format}
\alias{phylomatic_format}
\title{Get family names to make Phylomatic input object, and output input string
   to Phylomatic for use in the function phylomatic_tree.}
\usage{
phylomatic_format(taxa = NA, format = "isubmit", db = "ncbi")
}
\arguments{
\item{taxa}{quoted tsn number (taxonomic serial number)}

\item{format}{output format, isubmit (you can paste in to the Phylomatic
website), or 'rsubmit' to use in fxn phylomatic_tree}

\item{db}{One of "ncbi", "itis", or "apg"}
}
\value{
e.g., "pinaceae/pinus/pinus_contorta", in Phylomatic submission format.
}
\description{
Get family names to make Phylomatic input object, and output input string
   to Phylomatic for use in the function phylomatic_tree.
}
\examples{
\dontrun{
mynames <- c("Poa annua", "Salix goodingii", "Helianthus annuus")
phylomatic_format(mynames, format='rsubmit')
phylomatic_format(mynames, format='isubmit', db="apg")
}
}

