% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/resolve.R
\name{resolve}
\alias{resolve}
\title{Resolve names from different data sources}
\usage{
resolve(query, db = "gnr", ...)
}
\arguments{
\item{query}{Vector of one or more taxonomic names (common names not supported)}

\item{db}{Source to check names against. One of iplant, tnrs, or gnr. Default: gnr}

\item{...}{Curl options passed on to \code{\link[httr]{GET}} or \code{\link[httr]{POST}}.
In addition, further named args passed on to each respective function. See examples}
}
\value{
A list with length equal to length of the db parameter (number of
sources requested), with each element being a data.frame or list with results
from that source.
}
\description{
Resolve names from iPlant's name resolver, the Taxonomic Name
Resolution Service (TNRS), and the Global Names Resolver (GNR)
}
\examples{
\dontrun{
resolve(query=c("Helianthus annuus", "Homo sapiens"))
resolve(query="Quercus keloggii", db='gnr')
resolve(query=c("Helianthus annuus", "Homo sapiens"), db='tnrs')
resolve(query=c("Helianthus annuus", "Homo sapiens"), db=c('iplant', 'gnr'))
resolve(query="Quercus keloggii", db=c('iplant', 'gnr'))
resolve(query="Quercus keloggii", db=c('iplant', 'gnr', 'tnrs'))

# pass in options specific to each source
resolve("Helianthus annuus", db = 'gnr', preferred_data_sources = c(3, 4))
resolve("Helianthus annuus", db = 'iplant', retrieve = 'best')
identical(
 resolve("Helianthus annuus", db = 'iplant', retrieve = 'best')$iplant,
 iplant_resolve("Helianthus annuus", retrieve = 'best')
)
mynames <- c("Helianthus annuus", "Pinus contorta", "Poa annua",
   "Abies magnifica", "Rosa california")
resolve(mynames, db = 'tnrs', source = "NCBI")
resolve(mynames, db = 'tnrs', source = "iPlant_TNRS")
identical(
 resolve(mynames, db = 'tnrs', source = "iPlant_TNRS")$tnrs,
 tnrs(mynames, source = "iPlant_TNRS")
)

# pass in curl options
library("httr")
resolve(query="Qercuss", db = "iplant", config=verbose())
res <- resolve(query=c("Helianthus annuus", "Homo sapiens"), config=progress())
}
}

