% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/synonyms.R
\name{synonyms}
\alias{synonyms}
\alias{synonyms.colid}
\alias{synonyms.default}
\alias{synonyms.ids}
\alias{synonyms.nbnid}
\alias{synonyms.tpsid}
\alias{synonyms.tsn}
\title{Retrieve synonyms from various sources given input taxonomic names or identifiers.}
\usage{
synonyms(...)

\method{synonyms}{default}(x, db = NULL, rows = NA, ...)

\method{synonyms}{tsn}(id, ...)

\method{synonyms}{colid}(id, ...)

\method{synonyms}{tpsid}(id, ...)

\method{synonyms}{nbnid}(id, ...)

\method{synonyms}{ids}(id, ...)
}
\arguments{
\item{...}{Other passed arguments to internal functions \code{get_*()} and functions to
gather synonyms.}

\item{x}{Vector of taxa names (character) or IDs (character or numeric) to query.}

\item{db}{character; database to query. either \code{itis}, \code{tropicos},
\code{col}, or \code{nbn}.}

\item{rows}{(numeric) Any number from 1 to inifity. If the default NA, all rows are
considered. Note that this parameter is ignored if you pass in a taxonomic id of any of the
acceptable classes: tsn, tpsid, nbnid, ids.}

\item{id}{character; identifiers, returned by \code{\link[taxize]{get_tsn}},
\code{\link[taxize]{get_tpsid}}, or \code{\link[taxize]{get_nbnid}}}
}
\value{
A named list of data.frames with the synonyms of every supplied taxa.
}
\description{
Retrieve synonyms from various sources given input taxonomic names or identifiers.
}
\details{
If IDs are supplied directly (not from the \code{get_*} functions) you
must specify the type of ID.

For \code{db = "itis"} you can pass in a parameter \code{accepted} to toggle whether
only accepted names are used \code{accepted = TRUE}, or if all are used
\code{accepted = FALSE}. The default is \code{accepted = FALSE}.
}
\examples{
\dontrun{
# Plug in taxon IDs
synonyms("183327", db="itis")
synonyms("25509881", db="tropicos")
synonyms("NBNSYS0000004629", db='nbn')
synonyms("87e986b0873f648711900866fa8abde7", db='col')

# Plug in taxon names directly
synonyms("Pinus contorta", db="itis")
synonyms("Puma concolor", db="itis")
synonyms(c("Poa annua",'Pinus contorta','Puma concolor'), db="itis")
synonyms("Poa annua", db="tropicos")
synonyms("Pinus contorta", db="tropicos")
synonyms(c("Poa annua",'Pinus contorta'), db="tropicos")
synonyms("Pinus sylvestris", db='nbn')
synonyms("Puma concolor", db='col')
synonyms("Ursus americanus", db='col')
synonyms("Amblyomma rotundatum", db='col')

# not accepted names, with ITIS
## looks for whether the name given is an accepted name,
## and if not, uses the accepted name to look for synonyms
synonyms("Acer drummondii", db="itis")
synonyms("Spinus pinus", db="itis")

# Use get_* methods
synonyms(get_tsn("Poa annua"))
synonyms(get_tpsid("Poa annua"))
synonyms(get_nbnid("Carcharodon carcharias"))
synonyms(get_colid("Ornithodoros lagophilus"))

# Pass many ids from class "ids"
out <- get_ids(names="Poa annua", db = c('itis','tropicos'))
synonyms(out)

# Use the rows parameter to select certain rows
synonyms("Poa annua", db='tropicos', rows=1)
synonyms("Poa annua", db='tropicos', rows=1:3)
synonyms("Pinus sylvestris", db='nbn', rows=1:3)
synonyms("Amblyomma rotundatum", db='col', rows=2)
synonyms("Amblyomma rotundatum", db='col', rows=2:3)

# Use curl options
synonyms("Poa annua", db='tropicos', rows=1, config=verbose())
synonyms("Poa annua", db='itis', rows=1, config=verbose())
synonyms("Poa annua", db='col', rows=1, config=verbose())
}
}
\seealso{
\code{\link[taxize]{get_tsn}}, \code{\link[taxize]{get_tpsid}},
\code{\link[taxize]{get_nbnid}}
}

