% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxlist2taxmap.R
\name{taxlist2taxmap}
\alias{taxlist2taxmap}
\alias{taxlist2taxmap,taxlist-method}
\alias{taxmap2taxlist}
\title{Conversion among taxlist and taxmap objects}
\usage{
taxlist2taxmap(taxlist, ...)

\S4method{taxlist2taxmap}{taxlist}(taxlist, ...)

taxmap2taxlist(taxmap, relations, traits, synonyms, views, reindex = FALSE)
}
\arguments{
\item{taxlist}{Input object of class \linkS4class{taxlist}.}

\item{...}{Additional arguments passed among methods.}

\item{taxmap}{Input object of class \link{taxmap}.}

\item{relations, traits, synonyms, views}{Character values indicating the names
of data frames in the \link{taxmap} object at \code{data}, which should be
used for the slots taxonRelations, taxonTraits, taxonNames, and
taxonViews, respectively.}

\item{reindex}{Logical value indicating whether taxon IDs should be assigned
anew or not.}
}
\value{
Depending on the applied function, either a \linkS4class{taxlist} or a \code{Taxmap}
object.
}
\description{
Exchange of data between the packages \code{taxlist} and \code{taxa}.

This function should be used for the exchange of data between the packages
\link{taxlist-package} and \code{taxa}.
}
\examples{
## Subset Easplist
Cyperus <- subset(Easplist, grepl("Cyperus", TaxonName))

## Convert to taxmap 
Cyperus2 <- taxlist2taxmap(Cyperus)
Cyperus2

## Convert it back to taxlist
Cyperus2 <- taxmap2taxlist(taxmap=Cyperus2, traits="traits", views="views",
    synonyms="synonyms")
Cyperus2

}
\author{
Miguel Alvarez (\email{kamapu78@gmail.com}) and Zachary Foster
(\email{zacharyfoster1989@gmail.com}).
}
