% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcensReg_newton.R
\name{tcensReg_newton}
\alias{tcensReg_newton}
\title{Newton-Raphson Algorithm for Truncated Normal Distribution with Censoring with Linear Equation Mean}
\usage{
tcensReg_newton(
  y,
  X,
  a = -Inf,
  v = NULL,
  epsilon = 1e-04,
  tol_val = 1e-06,
  max_iter = 100,
  step_max = 10,
  theta_init = NULL
)
}
\arguments{
\item{y}{Numeric vector with the observed truncated and censored outcomes}

\item{X}{Numeric design matrix}

\item{a}{Numeric scalar indicating the truncation value. Initial value is -Inf indicating no truncation}

\item{v}{Numeric scalar indicating the censoring value. Initially set to NULL indicating no censoring}

\item{epsilon}{Numeric value used to define when the algorithm should stop when the gradient is less then epsilon. Default is 0.001}

\item{tol_val}{Tolerance value used to stop the algorithm if the (n+1) and (n) log likelihood is within the tolerance limit}

\item{max_iter}{Maximum number of iterations for algorithm. Default is 100}

\item{step_max}{Maximum number of steps when performing line search. Default is 10}

\item{theta_init}{Initial values of theta provided by the user. If unspecified then calculates values from OLS regression}
}
\value{
Returns a list of final estimate of theta, total number of iterations performed, initial log-likelihood,
final log-likelihood, and estimated variance covariance matrix.
}
\description{
Iteratively solve the optimization log likelihood problem using
Newton-Raphson algorithm with analytic gradient and Hessian values and step halving.
}
\keyword{internal}
