% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.pkmod}
\alias{predict.pkmod}
\title{Predict concentrations from a pkmod object}
\usage{
\method{predict}{pkmod}(
  object,
  ...,
  inf,
  tms = NULL,
  dtm = 1/6,
  return_init = FALSE,
  remove_bounds = TRUE
)
}
\arguments{
\item{object}{An object with class pkmod.}

\item{...}{Arguments passed on to pkmod}

\item{inf}{An infusion schedule object with columns "begin","end","infrt".}

\item{tms}{Times to evaluate predictions at. Will default to a sequence
spanning the infusions at intervals of dtm.}

\item{dtm}{Interval used for prediction if argument tms is unspecified.}

\item{return_init}{Logical indicating if concentrations at time 0 should
be returned. Defaults to FALSE.}

\item{remove_bounds}{Logical, indicating if concentrations calculated at
changes in infusion rates should be returned if not included in prediction
times. Defaults to TRUE, so that only concentrations at specified times
are returned.}
}
\value{
Returns predicted concentrations associated with 'object' with class
'pkmod' and infusion schedule 'inf'.
}
\description{
predict method to apply pk model piecewise to infusion schedule
}
