% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_mods.R
\name{pk_solution_3cpt_metab_singleinf}
\alias{pk_solution_3cpt_metab_singleinf}
\title{Single infusion 3-compartment PK solution}
\usage{
pk_solution_3cpt_metab_singleinf(pars, ivt, init, ce_only = FALSE)
}
\arguments{
\item{pars}{Named vector of parameters for a 3-compartment model with effect-site.}

\item{ivt}{Infusion schedule given in the form of a named list
(e.g. list(list(begin = 0, end = 2, k_R = 1), list(begin = 4, end = 6, k_R = 1)))}

\item{init}{Inital concentrations for the 4 compartments.}

\item{ce_only}{Logical. Should only the effect-site concentration be returned.
Defaults to FALSE}
}
\value{
Numeric matrix of concentrations for a three-compartment metabolite model
}
\description{
Piece-wise solution for a single infusion followed by a period with no infusion.
This function is similar to pk_solution_3cpt_metab, except that it accepts and
implements only the first infusion. This function exists primarily for
reducing computational speed when searching for time until maximum concentration.
}
\examples{
data(eleveld_pk)
data(eleveld_pd)
pk_pars <- subset(eleveld_pk, ID == 403, select = c("V1","V2","V3","CL","Q2","Q3"))
pd_pars <- subset(eleveld_pd, ID == 403, select = c("E50","KE0","EMAX","GAM","GAM1","RESD"))

pars <- c(k10 = pk_pars$CL / pk_pars$V1,
          k12 = pk_pars$Q2 / pk_pars$V1,
          k21 = pk_pars$Q2 / pk_pars$V2,
          k13 = pk_pars$Q3 / pk_pars$V1,
          k31 = pk_pars$Q3 / pk_pars$V3,
          v1 = pk_pars$V1,
          v2 = pk_pars$V2,
          v3 = pk_pars$V3,
          ke0 = pd_pars$KE0)
ivt <- list(begin = 0, end = 0.5, k_R = 1)
init <- c(0,0,0,0)
sol <- pk_solution_3cpt_metab_singleinf(pars, ivt, init)
sol(seq(0,5,0.1))
}
