% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscrFact.R
\name{plot.DiscrFact}
\alias{plot.DiscrFact}
\title{The \code{plot} method for objects of class \code{DiscrFact}}
\usage{
\method{plot}{DiscrFact}(
  x,
  enum.plots = FALSE,
  xlab = "Discriminant Factor",
  ylab = "Clusters",
  print.DiscrFact = TRUE,
  xlim,
  col.nodoubt = grey(0.8),
  by.cluster = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{DiscrFact} as returned from DiscrFact()}

\item{enum.plots}{A logical value indicating whether the plots shall be enumerated 
in their title ("(a)", "(b)", "(c)").}

\item{xlab, ylab, xlim}{Arguments passed to funcion \code{plot.tclust()}}

\item{print.DiscrFact}{A logical value indicating whether each clusters mean discriminant factor shall be plotted}

\item{col.nodoubt}{Color of all observations not considered as to be assigned doubtfully.}

\item{by.cluster}{Logical value indicating whether optional parameters pch and col 
(if present) refer to observations (FALSE) or clusters (TRUE)}

\item{\ldots}{Arguments to be passed to or from other methods}
}
\description{
The \code{plot} method for class \code{DiscrFact}: Next to a plot of the \code{tclust} 
 object which has been used for creating the \code{DiscrFact} object, a silhouette plot 
 indicates the presence of groups with a large amount of doubtfully assigned 
 observations. A third plot similar to the standard \code{tclust} plot serves 
 to highlight the identified doubtful observations.
}
\details{
\code{plot_DiscrFact_p2} displays a silhouette plot based on the discriminant 
 factors of the observations. A solution with many large discriminant factors is 
 not reliable. Such clusters can be identified with this silhouette plot. 
 Thus \code{plot_DiscrFact_p3} displays the dataset, highlighting observations with 
 discriminant factors greater than the given threshold. The function \code{plot.DiscrFact()} 
 combines the standard plot of a \code{tclust} object, and the two plots introduced here.
}
\examples{
 sig <- diag (2)
 cen <- rep (1, 2)
 x <- rbind(MASS::mvrnorm(360, cen * 0,   sig),
 	       MASS::mvrnorm(540, cen * 5,   sig * 6 - 2),
 	       MASS::mvrnorm(100, cen * 2.5, sig * 50))

 clus.1 <- tclust(x, k = 2, alpha=0.1, restr.fact=12)
 clus.2 <- tclust(x, k = 3, alpha=0.1, restr.fact=1)

 dsc.1 <- DiscrFact(clus.1)
 plot(dsc.1)

 dsc.2 <- DiscrFact(clus.2)
 plot(dsc.2)

}
\references{
\enc{García}{Garcia}-Escudero, L.A.; Gordaliza, A.; \enc{Matrán}{Matran}, C. and Mayo-Iscar, A. (2011), 
   "Exploring the number of groups in robust model-based clustering." \emph{Statistics and Computing}, \bold{21} 
   pp. 585-599, <doi:10.1007/s11222-010-9194-z>
}
