% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simul_tclust.R
\name{simula.tclust}
\alias{simula.tclust}
\title{Simulate contaminated data set for applying TCLUST}
\usage{
simula.tclust(n, p = 4, k = 3, type = 2, balanced = 1)
}
\arguments{
\item{n}{number of observations}

\item{p}{dimension (p>=2 and p>q)}

\item{k}{number of clusters (only k=3 and k=6 are allowed!!!)}

\item{type}{1 (spherical for rest.fact=1) or 2 (elliptical for rest.fact=9^2)}

\item{balanced}{1 (all clusters equal size) or 2 [proportions (25,30,35)\% if k=3 and (12.5,15,17.5,12.5,15,17.5)\% if k=6]}
}
\value{
a list with the following items
\itemize{
    \item x - The generated dataset
    \item true - The true classification
}
}
\description{
Simulate 10\% contaminated data set for applying TCLUST
}
\examples{
res <- simula.tclust(n=400,k=3,p=8,type=2,balanced=1)
plot(res$x,col=res$true+1)

}
