% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc5_mthds.R
\name{MC5_Methods}
\alias{MC5_Methods}
\alias{mc5_mthds}
\title{Load list of level 5 multiple-concentration cutoff methods}
\usage{
mc5_mthds(ae)
}
\arguments{
\item{ae}{Integer of length 1, the assay endpoint id}
}
\value{
A list of functions
}
\description{
\code{mc5_mthds} returns a list of additional activity cutoff methods
to be used during level 5 multiple-concentration processing.
}
\section{Available Methods}{


More information about the level 5 multiple-concentration processing is
available in the package vignette, "Pipeline_Overview."

\describe{
  \item{bmad3}{Add a cutoff value of 3*bmad.}
  \item{pc20}{Add a cutoff value of 20.}
  \item{log2_1.2}{Add a cutoff value of log2(1.2).}
  \item{log10_1.2}{Add a cutoff value of log10(1.2).}
  \item{bmad5}{Add a cutoff value of 5*bmad.}
  \item{bmad6}{Add a cutoff value of 6*bmad.}
  \item{bmad10}{Add a cutoff value of 10*bmad.}
  \item{log2_2}{Add a cutoff value of log2(2).}
  \item{log10_2}{Add a cutoff value of log10(2).}
  \item{neglog2_0.88}{Add a cutoff value of -1*log2(0.88).}
  \item{coff_2.32}{Add a cutoff value of 2.32.}
  
}
}

\seealso{
\code{\link{mc5}}, \code{\link{Method functions}} to query what
methods get applied to each aeid
}
