% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmdbounds.R
\name{bmdbounds}
\alias{bmdbounds}
\title{BMD Bounds}
\usage{
bmdbounds(
  fit_method,
  bmr,
  pars,
  conc,
  resp,
  onesidedp = 0.05,
  bmd = NULL,
  which.bound = "lower"
)
}
\arguments{
\item{fit_method}{Fit method: "exp2", "exp3", "exp4", "exp5", "hill", "gnls",
"poly1", "poly2", or "pow".}

\item{bmr}{Benchmark response.}

\item{pars}{Named vector of model parameters: a,b,tp,ga,p,la,q,er output by
httrfit, and in that order.}

\item{conc}{Vector of concentrations (NOT in log units).}

\item{resp}{Vector of responses corresponding to given concentrations.}

\item{onesidedp}{The one-sided p-value. Default of .05 corresponds to 5
percentile BMDL, 95 percentile BMDU, and 90 percent CI.}

\item{bmd}{Can optionally input the bmd when already known to avoid
unnecessary calculation.}

\item{which.bound}{Returns BMDU if which.bound = "upper"; returns BMDL if
which.bound = "lower".}
}
\value{
Returns either the BMDU or BMDL.
}
\description{
Uses maximum likelihood method to tune the upper and lower bounds on the BMD (BMDU, BMDL)
}
\details{
Takes in concentration response fit details and outputs a bmdu or bmdl, as
desired. If bmd is not finite, returns NA. If the objective function doesn't
change sign or the root finding otherwise fails, it returns NA. These
failures are not uncommon since some curves just don't reach the desired
confidence level.
}
\examples{
conc = c(.03, .1, .3, 1, 3, 10, 30, 100)
resp = c(.1,-.1,0,1.1,1.9,2,2.1,1.9)
pars = c(tp = 1.973356, ga = 0.9401224, p = 3.589397, er =  -2.698579)
bmdbounds(fit_method = "hill", bmr = .5, pars, conc, resp)
bmdbounds(fit_method = "hill", bmr = .5, pars, conc, resp, which.bound = "upper")
}
