% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toplikelihood.R
\name{toplikelihood}
\alias{toplikelihood}
\title{Top Likelihood}
\usage{
toplikelihood(fname, cutoff, conc, resp, ps, top, mll)
}
\arguments{
\item{fname}{Model function name (equal to model name except hill which
uses "hillfn")}

\item{cutoff}{Desired cutoff.}

\item{conc}{Vector of concentrations.}

\item{resp}{Vector of responses.}

\item{ps}{Vector of parameters, must be in order: a, tp, b, ga, p, la, q, er}

\item{top}{Model top.}

\item{mll}{Winning model maximum log-likelihood.}
}
\value{
Probability of top being above cutoff.
}
\description{
Probability of top being above cutoff.
}
\details{
Should only be called by hitcontinner. Uses profile likelihood, similar
to bmdbounds. Here, the y-scale type parameter is substituted in such a
way that the top equals the cutoff. Then the log-likelihood is compared to
the maximum log-likelihood using chisq function to retrieve probability.
}
\examples{
fname = "hillfn"
conc = c(.03,.1,.3,1,3,10,30,100)
resp = c(0,.1,0,.2,.6,.9,1.1,1)
ps = c(1.033239, 2.453014, 1.592714, er = -3.295307)
top = 1.023239
mll = 12.71495
toplikelihood(fname, cutoff = .8, conc, resp, ps, top, mll)
toplikelihood(fname, cutoff = 1, conc, resp, ps, top, mll)
toplikelihood(fname, cutoff = 1.2, conc, resp, ps, top, mll)
}
