% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitpoly2.R
\name{fitpoly2}
\alias{fitpoly2}
\title{Polynomial 2 (Quadratic) Model Fit}
\usage{
fitpoly2(
  conc,
  resp,
  bidirectional = TRUE,
  biphasic = TRUE,
  verbose = FALSE,
  nofit = FALSE,
  errfun = "dt4"
)
}
\arguments{
\item{conc}{Vector of concentration values NOT in log units.}

\item{resp}{Vector of corresponding responses.}

\item{bidirectional}{If TRUE, model can be positive or negative; if FALSE, it
will be positive only. (Only in use for monotonic poly2 fitting.)}

\item{biphasic}{If biphasic = TRUE, allows for biphasic polynomial 2
model fits (i.e. both monotonic and non-monotonic curves).
(Note, if FALSE fits \eqn{f(x) = a*(\frac{x}{b} + \frac{x^2}{b^2})}.)}

\item{verbose}{If TRUE, gives optimization and hessian inversion details.}

\item{nofit}{If nofit = TRUE, returns formatted output filled with missing values.}

\item{errfun}{Which error distribution to assume for each point, defaults to
"dt4". "dt4" is the original 4 degrees of freedom t-distribution. Another
supported distribution is "dnorm", the normal distribution.}
}
\value{
Named list containing: success, aic (Akaike Information Criteria),
  cov (success of covariance calculation), rme (root mean square error),
  modl (vector of model values at given concentrations),
  parameters values, parameter sd (standard deviation) estimates, pars
  (vector of parameter names), sds (vector of parameter sd names).
}
\description{
Function that fits to \eqn{f(x) = b1*x + b2*x^2} (biphasic), or
\eqn{f(x) = a*(\frac{x}{b} + \frac{x^2}{b^2})} (monotonic only), and
returns generic model outputs.
}
\details{
(Biphasic Poly2 Model) Zero background is assumed and responses may be
biphasic (non-monotonic).  Parameters are "b1" (shift along x-axis),
"b2" (rate of change, direction, and the shift along y-axis),
and error term "er".
(Monotonic Poly2 Model) Zero background and monotonically increasing
absolute response are assumed.
Parameters are "a" (y scale), "b" (x scale), and error term "er".
(Biphasic or Monotonic Poly2 Fit) success = 1 for a successful fit, 0 if
optimization failed, and NA if nofit = TRUE.
cov = 1 for a successful hessian inversion, 0 if it fails, and NA
if nofit = TRUE. aic, rme, modl, parameters, and parameter sds are set to
NA in case of nofit or failure.
}
\examples{
fitpoly2(c(.03,.1,.3,1,3,10,30,100), c(0,.01,.1, .1, .2, .5, 2, 8))
}
