% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency.R
\name{f.x.times.a.day}
\alias{f.x.times.a.day}
\title{Creates an \code{X-Times-A-Day} Frequency}
\usage{
f.x.times.a.day(day, x, position)
}
\arguments{
\item{day}{A 'Day-based' object of class \code{ldtf}, such as \code{Daily} or \code{Daily-In-Week}.}

\item{x}{Number of observations in each day.}

\item{position}{Position of the current observation. It should be a positive integer. It cannot be larger than \code{x}.}
}
\value{
An object of class 'ldtf'. It is also a list with the following members:
\tabular{ll}{
\code{class} \tab Determines the class of this frequency.\cr
\code{day} \tab Determines the \code{day}.\cr
\code{second} \tab Determines the \code{second}.
}
}
\description{
Use it to create a frequency for time-series data that occurs \code{x} times in day or a subset of a week.
}
\details{
In order to use \code{\link{as.frequency}} function for this type of frequency,
you need the following information:
\itemize{
\item \strong{Character Format} \code{"#"} (in which '#' is the value: \code{position})
\item \strong{Class Id} \code{"da#|..."} (in which '#' is the value: \code{x} and '...' is the 'Class String' of \code{day}))
}
}
\examples{

xd0 <- f.x.times.a.day(f.daily(2023,5,16),13, 12)

xd0_value_str <-  as.character(xd0) # this will be '20230516:12'.
xd0_class_str <- get.class.id(xd0)
#      this will be 'da13|d'. The second part (i.e., 'd')
#      shows that this frequency is defined in a 'Daily' frequency.

xd_new <- as.frequency("20231101:3", "da3|i:wed-sat")

# Don't make the following mistakes:
\donttest{
xd_invalid <- try(as.frequency("20231101:3", "da|i:wed-sat"))
#  invalid format in day-based frequency
xd_invalid <- try(f.x.times.a.day(f.daily(2023,5,16),4,0)) # invalid position
}

}
