% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency.R
\name{f.daily.in.week}
\alias{f.daily.in.week}
\title{Create a \code{Daily-In-Week} Frequency}
\usage{
f.daily.in.week(date, weekStart = "mon", weekEnd = "fri", forward = TRUE)
}
\arguments{
\item{date}{The date, which can be a list with \code{year}, \code{month}, and \code{day} elements.
It can also be an integer array with 3 elements for year, month, and day respectively,
or an object that can be used as an argument for the \code{base::as.Date} function.}

\item{weekStart}{The first day of the week, which can be \code{sun}, \code{mon}, \code{tue}, \code{wed}, \code{thu}, \code{fri}, or \code{sat}.}

\item{weekEnd}{The last day of the week, which can be one of the values listed for \code{weekStart}. Together, they define the week.}

\item{forward}{If the current date is not in the week and this value is true, it moves forward to the first day of the week. If this value is false, it moves backward to the last day of the week.}
}
\value{
An object of class \code{ldtf}. It is also a list with the following members:
\item{class}{Determines the class of this frequency.}
\item{year}{Determines the \code{year}.}
\item{month}{Determines the \code{month}.}
\item{day}{Determines the \code{day}.}
\item{weekStart}{Determines the \code{weekStart}.}
\item{weekEnd}{Determines the \code{weekEnd}.}
}
\description{
Use this function to create a frequency for time-series data that occurs daily within a subset of a week. The first day of the interval is used as the reference.
}
\details{
In order to use the \code{\link{as.frequency}} function for this type of frequency,
you need the following information:
\itemize{
\item \strong{Character Format}: The first day of the interval in \code{"YYYYMMDD"} format.
\item \strong{Class Id}: \code{"i:...-..."} (where the first '...' represents \code{weekStart} and the second '...' represents \code{weekEnd}; e.g., \code{i:mon-fri} means a week from Monday to Friday)
}
}
\examples{

dw0 <- f.daily.in.week(c(2023, 5, 16), "mon", "fri") # This is 16/5/2023.
dw0_value_str <-  as.character(dw0) # this will be '20230516'.
dw0_class_str <- get.class.id(dw0) # this will be 'i:mon-fri'.

# Let's use the same date with another week definition:
dw1 <- f.daily.in.week(c(2023, 5, 16), "wed", "sat")
#     This is NOT 16/5/2023. It is 17/5/2023.
#     Since it was outside the week, we moved it forward.
dw2 <- f.daily.in.week(c(2023, 5, 16), "wed", "sat", FALSE)
#     This is 13/5/2023. The original day was outside the
#     week, but we moved backward too the end of
#     the previous week (which is Saturday).

dw_new <- as.frequency("20230519", "i:sat-wed")
#     This is 20/1/2023 (by default, it moves forward).

# Don't use invalid or unsupported dates:
\donttest{
dw_invalid <- try(as.frequency("1399109", "d3")) # this is a too old date and unsupported
dw_invalid <- try(as.frequency("20230132", "d4")) # invalid day in month
dw_invalid <- try(as.frequency("20231331", "d5")) # invalid month

# don't use invalid week definitions:
dw_invalid <- try(f.daily.in.week(c(2023, 5, 16), "Wednesday", "sat"))
}

}
