\name{TmixDistIF}
\alias{tcdfpdf}
\alias{tinvvw}
\title{The internal functions for coputation of the cdf, pdf and quantile
function of a linear combination of independent Student's t-variables}
\description{The \code{tcdfpdf} computes cdf and/or pdf and the \code{tinvvw}
quantile function of a linear combination of independent Student's t-variables
with small degrees of freedom (df <= 100).}
\usage{
tcdfpdf(x, tt, wf, funtype = 0, nr)
tinvvw(p, tt, wf, nr)
}
\arguments{
For \code{tcdfpdf} and \code{tinvvw}:
\item{x}{vector of real number in wich cdf and pdf is evaluated.}
\item{p}{vector of probabilities.}
\item{tt}{base points generated by \code{gweights}.}
\item{wf}{weight facotrs generated by \code{gweights}.}
\item{funtype}{default value is 0 (calculates the cdf and pdf). The following
funtypes are legible: \cr
0: tdist calculates cdf and pdf at once, \code{yfun = cbind(cdf, pdf)}. \cr
1: tdist calculates the cumulative distribution function, cdf at funx,
\code{yfun = cdf}. \cr
2: tdist calculates the probability density function, pdf at funx,
\code{yfun = pdf}.}
\item{nr}{norm of lambda coefficients.}
}
\value{
The \code{tcdfpdf} gives vector/matrix with calculated function values, the
result depends on funtype. If \code{funtype = 0}, value is a matrix with two
columns (cdf and pdf). \cr
The \code{tinvvw} gives a list of
\item{yfun}{vector with calculated function values.}
\item{xfun}{vector of function input values. Typically \code{xfun = funx}.
If \code{funx = numeric(0)}, xfun is generated automatically.}
\item{error}{Error message. If \code{error = 1}, some problem has occured during
calculation, see the warning message. If \code{error = 0}, corret calculations.}
}
\author{Viktor Witkovsky \email{witkovsky@savba.sk}. Rewritten from Matlab
algorithm to R by Alexander Savin \email{savin@savba.sk}.}
\seealso{\code{gweights}, \code{\link{tchfvw}}, \code{\link{tdist}}.}
\keyword{distribution}
