ui = fluidPage(theme = add_theme(getShinyOption('theme')), 
               add_css(),
               
sidebarLayout(
   sidebarPanel(width = 3,
      hr(),
      sliderInput("rangebisa", 
                  label = "Range",
                  min = 0, 
                  max = 20, 
                  value = c(0,4)),
      hr(),
      sliderInput("be.bisa", 
                  label = HTML("Shape (&beta;)"),
                  min = 0.5, 
                  max = 10, 
                  step = 0.5, 
                  value = 1, 
                  animate = TRUE),
      hr(),
      sliderInput("th.bisa", 
                  label = HTML("Scale (&theta;)"),
                  min = 0.5, 
                  max = 10, 
                  step = 0.5, 
                  value = 1,
                  animate = TRUE)),

  mainPanel(width = 9,
    tabsetPanel(type = 'pills',
      tabPanel('Distribution Function',
               metricsgraphicsOutput(height = "550px", "bisaC")),
      tabPanel('Density',              
               metricsgraphicsOutput(height = "550px", "bisaP")),
      tabPanel('Survival',
               metricsgraphicsOutput(height = "550px", "bisaR")),
      tabPanel('Hazard',
               metricsgraphicsOutput(height = "550px", "bisah")),
      tabPanel('Cumulative Hazard',
               metricsgraphicsOutput(height = "550px", "bisaH")),
      tabPanel('Quantile',
               metricsgraphicsOutput(height = "550px", "bisaQ"))))))
