% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qenv-eval_code.R, R/qenv-within.R
\name{eval_code}
\alias{eval_code}
\alias{eval_code,qenv,character-method}
\alias{eval_code,qenv,language-method}
\alias{eval_code,qenv,expression-method}
\alias{eval_code,qenv.error,ANY-method}
\alias{within.qenv}
\title{Evaluate code in \code{qenv}}
\usage{
eval_code(object, code)

\method{within}{qenv}(data, expr, ...)
}
\arguments{
\item{object}{(\code{qenv})}

\item{code}{(\code{character}, \code{language} or \code{expression}) code to evaluate.
It is possible to preserve original formatting of the \code{code} by providing a \code{character} or an
\code{expression} being a result of \code{parse(keep.source = TRUE)}.}

\item{data}{(\code{qenv})}

\item{expr}{(\code{expression}) to evaluate. Must be inline code, see \verb{Using language objects...}}

\item{...}{named argument value will substitute a symbol in the \code{expr} matched by the name.
For practical usage see Examples section below.}
}
\value{
\code{qenv} environment with \code{code/expr} evaluated or \code{qenv.error} if evaluation fails.
}
\description{
Evaluate code in \code{qenv}
}
\details{
\code{eval_code()} evaluates given code in the \code{qenv} environment and appends it to the \code{code} slot.
Thus, if the \code{qenv} had been instantiated empty, contents of the environment are always a result of the stored code.

\code{within()} is a convenience method that wraps \code{eval_code} to provide a simplified way of passing expression.
\code{within} accepts only inline expressions (both simple and compound) and allows to substitute \code{expr}
with \code{...} named argument values.
}
\section{Using language objects with \code{within}}{

Passing language objects to \code{expr} is generally not intended but can be achieved with \code{do.call}.
Only single \code{expression}s will work and substitution is not available. See examples.
}

\examples{
# evaluate code in qenv
q <- qenv()
q <- eval_code(q, "a <- 1")
q <- eval_code(q, "b <- 2L # with comment")
q <- eval_code(q, quote(library(checkmate)))
q <- eval_code(q, expression(assert_number(a)))

# evaluate code using within
q <- qenv()
q <- within(q, {
  i <- iris
})
q <- within(q, {
  m <- mtcars
  f <- faithful
})
q
get_code(q)

# inject values into code
q <- qenv()
q <- within(q, i <- iris)
within(q, print(dim(subset(i, Species == "virginica"))))
within(q, print(dim(subset(i, Species == species)))) # fails
within(q, print(dim(subset(i, Species == species))), species = "versicolor")
species_external <- "versicolor"
within(q, print(dim(subset(i, Species == species))), species = species_external)

# pass language objects
expr <- expression(i <- iris, m <- mtcars)
within(q, expr) # fails
do.call(within, list(q, expr))

exprlist <- list(expression(i <- iris), expression(m <- mtcars))
within(q, exprlist) # fails
do.call(within, list(q, do.call(c, exprlist)))

}
