% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{add_facet_labels}
\alias{add_facet_labels}
\title{Add labels for facets to a \code{ggplot2} object}
\usage{
add_facet_labels(p, xfacet_label = NULL, yfacet_label = NULL)
}
\arguments{
\item{p}{(\code{ggplot2}) object to which facet labels will be added.}

\item{xfacet_label}{(\code{character}) Label for the facet along the x-axis.
If \code{NULL}, no label is added. If a vector, labels are joined with " & ".}

\item{yfacet_label}{(\code{character}) Label for the facet along the y-axis.
Similar behavior to \code{xfacet_label}.}
}
\value{
Returns \code{grid} or \code{grob} object (to be drawn with \code{grid.draw})
}
\description{
Enhances a \code{ggplot2} plot by adding labels that describe
the faceting variables along the x and y axes.
}
\examples{
library(ggplot2)
library(grid)

p <- ggplot(mtcars) +
  aes(x = mpg, y = disp) +
  geom_point() +
  facet_grid(gear ~ cyl)

xfacet_label <- "cylinders"
yfacet_label <- "gear"
res <- add_facet_labels(p, xfacet_label, yfacet_label)
grid.newpage()
grid.draw(res)

grid.newpage()
grid.draw(add_facet_labels(p, xfacet_label = NULL, yfacet_label))
grid.newpage()
grid.draw(add_facet_labels(p, xfacet_label, yfacet_label = NULL))
grid.newpage()
grid.draw(add_facet_labels(p, xfacet_label = NULL, yfacet_label = NULL))

}
