% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teal_slices.R
\name{teal_slices}
\alias{teal_slices}
\alias{as.teal_slices}
\alias{c.teal_slices}
\title{Filter settings for \code{teal} applications}
\usage{
teal_slices(
  ...,
  exclude_varnames = NULL,
  include_varnames = NULL,
  count_type = NULL,
  allow_add = TRUE,
  module_specific = FALSE,
  mapping,
  app_id = NULL
)

as.teal_slices(x)

\method{c}{teal_slices}(...)
}
\arguments{
\item{...}{any number of \code{teal_slice} objects. For \code{print} and \code{format},
additional arguments passed to other functions.}

\item{include_varnames, exclude_varnames}{(\verb{named list}s of \code{character}) where list names
match names of data sets and vector elements match variable names in respective data sets;
specify which variables are allowed to be filtered; see \code{Details}.}

\item{count_type}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
\emph{This is a new feature. Do kindly share your opinions on
\href{https://github.com/insightsengineering/teal.slice/}{\code{teal.slice}'s GitHub repository}.}

(\code{character(1)}) string specifying how observations are tallied by these filter states.
Possible options:
\itemize{
\item \code{"none"} (default) to have counts of single \code{FilterState} to show unfiltered number only.
\item \code{"all"} to have counts of single \code{FilterState} to show number of observation in filtered
and unfiltered dataset. Note, that issues were reported when using this option with \code{MultiAssayExperiment}.
Please make sure that adding new filters doesn't fail on target platform before deploying for production.
}}

\item{allow_add}{(\code{logical(1)}) logical flag specifying whether the user will be able to add new filters}

\item{module_specific}{optional (\code{logical(1)})
\itemize{
\item \code{FALSE} (default) when one filter panel applied to all modules.
All filters will be shared by all modules.
\item \code{TRUE} when filter panel module-specific.
Modules can have different set of filters specified - see \code{mapping} argument.
}}

\item{mapping}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
\emph{This is a new feature. Do kindly share your opinions on
\href{https://github.com/insightsengineering/teal/}{\code{teal}'s GitHub repository}.}

(named \code{list}) specifies which filters will be active in which modules on app start.
Elements should contain character vector of \code{teal_slice} \code{id}s (see \code{\link[teal.slice:teal_slice]{teal.slice::teal_slice}}).
Names of the list should correspond to \code{teal_module} \code{label} set in \code{\link[=module]{module()}} function.
\itemize{
\item \code{id}s listed under \verb{"global_filters} will be active in all modules.
\item If missing, all filters will be applied to all modules.
\item If empty list, all filters will be available to all modules but will start inactive.
\item If \code{module_specific} is \code{FALSE}, only \code{global_filters} will be active on start.
}}

\item{app_id}{(\code{character(1)})
For internal use only, do not set manually.
Added by \code{init} so that a \code{teal_slices} can be matched to the app in which it was used.
Used for verifying snapshots uploaded from file. See \code{snapshot}.}

\item{x}{(\code{list}) of lists to convert to \code{teal_slices}}
}
\value{
A \code{teal_slices} object.
}
\description{
Specify initial filter states and filtering settings for a \code{teal} app.
}
\details{
Produces a \code{teal_slices} object.
The \code{teal_slice} components will specify filter states that will be active when the app starts.
Attributes (created with the named arguments) will configure the way the app applies filters.
See argument descriptions for details.
}
\examples{
filter <- teal_slices(
  teal_slice(dataname = "iris", varname = "Species", id = "species"),
  teal_slice(dataname = "iris", varname = "Sepal.Length", id = "sepal_length"),
  teal_slice(
    dataname = "iris", id = "long_petals", title = "Long petals", expr = "Petal.Length > 5"
  ),
  teal_slice(dataname = "mtcars", varname = "mpg", id = "mtcars_mpg"),
  mapping = list(
    module1 = c("species", "sepal_length"),
    module2 = c("mtcars_mpg"),
    global_filters = "long_petals"
  )
)

app <- init(
  data = teal_data(iris = iris, mtcars = mtcars),
  modules = list(
    module("module1"),
    module("module2")
  ),
  filter = filter
)

if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
\seealso{
\code{\link[teal.slice:teal_slices]{teal.slice::teal_slices}}, \code{\link[teal.slice:teal_slice]{teal.slice::teal_slice}}, \code{\link[=slices_store]{slices_store()}}
}
\keyword{internal}
