% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_teal_data.R
\name{module_teal_data}
\alias{module_teal_data}
\alias{ui_teal_data_module}
\alias{ui_teal_data}
\alias{srv_teal_data_module}
\alias{srv_teal_data}
\alias{ui_validate_reactive_teal_data}
\alias{srv_validate_reactive_teal_data}
\title{Execute and validate \code{teal_data_module}}
\usage{
ui_teal_data_module(id, data_module = function(id) NULL)

srv_teal_data_module(
  id,
  data_module = function(id) NULL,
  modules = NULL,
  validate_shiny_silent_error = TRUE,
  is_transform_failed = reactiveValues()
)

ui_validate_reactive_teal_data(id)

srv_validate_reactive_teal_data(
  id,
  data,
  modules = NULL,
  validate_shiny_silent_error = FALSE,
  hide_validation_error = reactive(FALSE)
)
}
\arguments{
\item{id}{(\code{character(1)}) \code{shiny} module instance id.}

\item{data_module}{(\code{teal_data_module})}

\item{modules}{(\code{teal_modules} or \code{teal_module}) For \code{datanames} validation purpose}

\item{validate_shiny_silent_error}{(\code{logical}) If \code{TRUE}, then \code{shiny.silent.error} is validated and}

\item{is_transform_failed}{(\code{reactiveValues}) contains \code{logical} flags named after each transformator.
Help to determine if any previous transformator failed, so that following transformators can be disabled
and display a generic failure message.}

\item{data}{(\code{teal_data}, \code{teal_data_module}, or \code{reactive} returning \code{teal_data})
The data which application will depend on.}
}
\value{
\code{reactive} \code{teal_data}
}
\description{
This is a low level module to handle \code{teal_data_module} execution and validation.
\code{\link[=teal_transform_module]{teal_transform_module()}} inherits from \code{\link[=teal_data_module]{teal_data_module()}} so it is handled by this module too.
\code{\link[=srv_teal]{srv_teal()}} accepts various \code{data} objects and eventually they are all transformed to \code{reactive}
\code{\link[teal.data:teal_data]{teal.data::teal_data()}} which is a standard data class in whole \code{teal} framework.
}
\note{
\code{ui_teal_data_module} was renamed from \code{ui_teal_data}.

\code{srv_teal_data_module} was renamed from \code{srv_teal_data}.
}
\section{data validation}{


Executed \code{\link[=teal_data_module]{teal_data_module()}} is validated and output is validated for consistency.
Output \code{data} is invalid if:
\enumerate{
\item \code{\link[=teal_data_module]{teal_data_module()}} is invalid if server doesn't return \code{reactive}. \strong{Immediately crashes an app!}
\item \code{reactive} throws a \code{shiny.error} - happens when module creating \code{\link[teal.data:teal_data]{teal.data::teal_data()}} fails.
\item \code{reactive} returns \code{qenv.error} - happens when \code{\link[teal.data:teal_data]{teal.data::teal_data()}} evaluates a failing code.
\item \code{reactive} object doesn't return \code{\link[teal.data:teal_data]{teal.data::teal_data()}}.
\item \code{\link[teal.data:teal_data]{teal.data::teal_data()}} object lacks any \code{datanames} specified in the \code{modules} argument.
}

\code{teal} (observers in \code{srv_teal}) always waits to render an app until \code{reactive} \code{teal_data} is
returned. If error 2-4 occurs, relevant error message is displayed to the app user. Once the issue is
resolved, the app will continue to run. \code{teal} guarantees that errors in data don't crash the app
(except error 1).
}

\keyword{internal}
