% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ar.R
\name{Ar}
\alias{Ar}
\title{Ar: Archimedes number}
\usage{
Ar(T_leaf, pars, unitless = FALSE)
}
\arguments{
\item{T_leaf}{Leaf temperature in Kelvin}

\item{pars}{Concatenated parameters (\code{leaf_par}, \code{enviro_par}, and \code{constants})}

\item{unitless}{Logical. Should function use parameters with \code{units}? The function is faster when FALSE, but input must be in correct units or else results will be incorrect without any warning.}
}
\value{
\code{unitless = TRUE}: A unitless number of class \code{numeric} 
\code{unitless = FALSE}: A unitless number of class \code{units} 
Also returns Reynolds and Grashof numbers
}
\description{
Ar: Archimedes number
}
\details{
The Archimedes number is a dimensionless number that describes when free or forced convection dominates.

\deqn{Ar = Gr / Re ^ 2}
\cr
\tabular{lllll}{
\emph{Symbol} \tab \emph{R} \tab \emph{Description} \tab \emph{Units} \tab \emph{Default}\cr
\eqn{Gr} \tab \code{Gr} \tab Grashof number \tab none \tab \link[=.get_gr]{calculated}\cr
\eqn{Re} \tab \code{Re} \tab Reynolds number \tab none \tab \link[=.get_re]{calculated}
}
}
\examples{
cs <- make_constants()
lp <- make_enviropar()
ep <- make_leafpar()
pars <- c(cs, lp, ep)
T_leaf <- set_units(298.15, "K")

Ar(T_leaf, pars)

}
