#' Example stress data for tangentially displaced plate boundary
#'
#' Subset of the World Stress Map (WSM) compilation of information on the
#' crustal present-day stress field (Version 1.1. 2019). Subset contains stress data
#' adjacent to the San Andreas Fault.
#'
#' @docType data
#'
#' @usage data('san_andreas')
#'
#' @format An object of class \code{"sf"}
#'
#' @references Heidbach, O., M. Rajabi, X. Cui, K. Fuchs, B. M<U+00FC>ller, J.
#' Reinecker, K. Reiter, M. Tingay, F. Wenzel, F. Xie, M. O. Ziegler,
#' M.-L. Zoback, and M. D. Zoback (2018): The World Stress Map database
#' release 2016: Crustal stress pattern across scales. *Tectonophysics*,
#' **744**, 484-498, \doi{10.1016/j.tecto.2018.07.007}.
#'
#' @source \url{https://www.world-stress-map.org/}
#'
#' @keywords datasets
#'
#' @examples
#' data("san_andreas")
#' head(san_andreas)
"san_andreas"

#' Example stress data for inward-moving displaced plate boundary
#'
#' Subset of the World Stress Map (WSM) compilation of information on the
#' crustal present-day stress field (Version 1.1. 2019). Subset contains stress data
#' of the Himalaya and Tibetan plateau
#'
#' @docType data
#'
#' @usage data('tibet')
#'
#' @format An object of class \code{"sf"}
#'
#' @references Heidbach, O., M. Rajabi, X. Cui, K. Fuchs, B. M<U+00FC>ller, J.
#' Reinecker, K. Reiter, M. Tingay, F. Wenzel, F. Xie, M. O. Ziegler,
#' M.-L. Zoback, and M. D. Zoback (2018): The World Stress Map database
#' release 2016: Crustal stress pattern across scales. *Tectonophysics*,
#' **744**, 484-498, \doi{10.1016/j.tecto.2018.07.007}.
#'
#' @source \url{https://www.world-stress-map.org/}
#'
#' @keywords datasets
#'
#' @examples
#' data("tibet")
#' head(tibet)
"tibet"

#' Example stress data for outward-moving displaced plate boundary
#'
#' Subset of the World Stress Map (WSM) compilation of information on the
#' crustal present-day stress field (Version 1.1. 2019). Subset contains stress data
#' of Iceland.
#'
#' @docType data
#'
#' @usage data('iceland')
#'
#' @format An object of class \code{"sf"}
#'
#' @references Heidbach, O., M. Rajabi, X. Cui, K. Fuchs, B. M<U+00FC>ller, J.
#' Reinecker, K. Reiter, M. Tingay, F. Wenzel, F. Xie, M. O. Ziegler,
#' M.-L. Zoback, and M. D. Zoback (2018): The World Stress Map database
#' release 2016: Crustal stress pattern across scales. *Tectonophysics*,
#' **744**, 484-498, \doi{10.1016/j.tecto.2018.07.007}.
#'
#' @source \url{https://www.world-stress-map.org/}
#'
#' @keywords datasets
#'
#' @examples
#' data("iceland")
#' head(iceland)
"iceland"
