% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_2.R
\name{vt2_lasso}
\alias{vt2_lasso}
\title{Estimate the CATE using the Lasso for Step 2}
\usage{
vt2_lasso(z, data, Trt, Y, theta)
}
\arguments{
\item{z}{a numeric vector of estimated CATEs from Step 1}

\item{data}{a data frame containing a response, binary treatment indicators,
and covariates.}

\item{Trt}{a string specifying the name of the column of \code{data}
contains the treatment indicators.}

\item{Y}{a string specifying the name of the column of \code{data}
contains the response.}

\item{theta}{lasso penalty parameter (\code{lambda})}
}
\value{
a list of length 3 containing the following elements:
\item{mod}{an object of class \code{glmnet}. See
\code{\link[glmnet]{glmnet}}.}
\item{coefficients}{coefficients associated with the penalty parameter
\code{theta}.}
\item{fitted.values}{predicted values associated with the penalty parameter
\code{theta}.}
}
\description{
Estimate the CATE using the Lasso for Step 2
}
\seealso{
Other VT Step 2 functions: 
\code{\link{vt2_ctree}()},
\code{\link{vt2_rtree}()}
}
\concept{VT Step 2 functions}
