% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bot.R
\docType{class}
\name{Bot}
\alias{Bot}
\alias{is.Bot}
\title{Creating a Bot}
\format{
An \code{\link{R6Class}} object.
}
\usage{
Bot(token, base_url = NULL, base_file_url = NULL, request_config = NULL)

is.Bot(x)
}
\arguments{
\item{token}{The bot's token given by the \emph{BotFather}.}

\item{base_url}{(Optional). Telegram Bot API service URL.}

\item{base_file_url}{(Optional). Telegram Bot API file URL.}

\item{request_config}{(Optional). Additional configuration settings
    to be passed to the bot's POST requests. See the \code{config}
    parameter from \code{?httr::POST} for further details.

    The \code{request_config} settings are very
    useful for the advanced users who would like to control the
    default timeouts and/or control the proxy used for HTTP communication.}

\item{x}{Object to be tested.}
}
\description{
This object represents a Telegram Bot.
}
\details{
To take full advantage of this library take a look at \code{\link{Updater}}.

You can also use its methods \code{snake_case} equivalent.
}
\section{API Methods}{
 \describe{
    \item{\code{\link{answerCallbackQuery}}}{Send
    answers to callback queries}
    \item{\code{\link{answerInlineQuery}}}{Send answers to an inline query}
    \item{\code{\link{deleteMessage}}}{Delete a message}
    \item{\code{\link{deleteWebhook}}}{Remove webhook integration}
    \item{\code{\link{editMessageText}}}{Edit a text message}
    \item{\code{\link{editMessageCaption}}}{Edit a caption}
    \item{\code{\link{editMessageReplyMarkup}}}{Edit the reply
    markup of a message}
    \item{\code{\link{forwardMessage}}}{Forward messages of any
    kind}
    \item{\code{\link{getFile}}}{Prepare a file for downloading}
    \item{\code{\link{getMe}}}{Check your bot's information}
    \item{\code{\link{getUpdates}}}{Receive incoming
    updates}
    \item{\code{\link{getUserProfilePhotos}}}{Get a user's profile photos}
    \item{\code{\link{getWebhookInfo}}}{Get current webhook status}
    \item{\code{\link{leaveChat}}}{Leave a chat}
    \item{\code{\link{sendAnimation}}}{Send animation files}
    \item{\code{\link{sendAudio}}}{Send audio files}
    \item{\code{\link{sendChatAction}}}{Send a chat action}
    \item{\code{\link{sendDocument}}}{Send general files}
    \item{\code{\link{sendLocation}}}{Send point on the map}
    \item{\code{\link{sendMessage}}}{Send text messages}
    \item{\code{\link{sendPhoto}}}{Send image files}
    \item{\code{\link{sendSticker}}}{Send a sticker}
    \item{\code{\link{sendVideo}}}{Send a video}
    \item{\code{\link{sendVideoNote}}}{Send video messages}
    \item{\code{\link{sendVoice}}}{Send voice files}
    \item{\code{\link{setWebhook}}}{Set a webhook}
}
}

\section{Other Methods}{
 \describe{
    \item{\code{\link{clean_updates}}}{Clean any pending updates}
    \item{\code{\link{set_token}}}{Change your bot's auth token}
}
}

\examples{
\dontrun{
bot <- Bot(token = "TOKEN")

# In case you want to set a proxy (see ?httr:use_proxy)
bot <- Bot(
  token = "TOKEN",
  request_config = httr::use_proxy(...)
)
}
}
