\name{tensorBSS-package}
\alias{tensorBSS-package}
\alias{tensorBSS}
\docType{package}
\title{
Blind Source Separation Methods for Tensor-Valued Observations
}
\description{
Contains several utility functions for manipulating tensor-valued data (centering, multiplication from a single mode etc.) and 
the implementations of the following blind source separation methods for tensor-valued data: \sQuote{tPCA}, \sQuote{tFOBI}, \sQuote{tJADE}, \sQuote{k-tJADE}, \sQuote{tgFOBI}, \sQuote{tgJADE}, \sQuote{tSOBI}, \sQuote{tNSS.SD}, \sQuote{tNSS.JD}, \sQuote{tNSS.TD.JD}, \sQuote{tPP} and \sQuote{tTUCKER}.
}
\details{
\tabular{ll}{
Package: \tab tensorBSS\cr
Type: \tab Package\cr
Version: \tab 0.3.8\cr
Date: \tab 2021-06-02\cr
License: \tab GPL (>= 2)\cr
}


}
\author{
Joni Virta, Christoph Koesner, Bing Li, Klaus Nordhausen, Hannu Oja and Una Radojicic

Maintainer: Joni Virta <joni.virta@outlook.com>
}

\references{
\cite{Virta, J., Taskinen, S. and Nordhausen, K. (2016), Applying fully tensorial ICA to fMRI data, Signal Processing in Medicine and Biology Symposium (SPMB), 2016 IEEE, \doi{10.1109/SPMB.2016.7846858}} 

\cite{Virta, J., Li, B., Nordhausen, K. and Oja, H., (2017), Independent component analysis for tensor-valued data, Journal of Multivariate Analysis, \doi{10.1016/j.jmva.2017.09.008}}

\cite{Virta, J. and Nordhausen, K., (2017), Blind source separation of tensor-valued time series. Signal Processing 141, 204-216, \doi{10.1016/j.sigpro.2017.06.008}}  

\cite{Virta J., Nordhausen K. (2017): Blind source separation for nonstationary tensor-valued time series, 2017 IEEE 27th International Workshop on Machine Learning for Signal Processing (MLSP), \doi{10.1109/MLSP.2017.8168122}}

\cite{Virta J., Li B., Nordhausen K., Oja H. (2018): JADE for tensor-valued observations, Journal of Computational and Graphical Statistics, 27, 628 - 637, \doi{10.1080/10618600.2017.1407324}} 

\cite{Virta J., Lietzen N., Ilmonen P., Nordhausen K. (2021): Fast tensorial JADE, Scandinavian Journal of Statistics, 48, 164-187, \doi{10.1111/sjos.12445}}

\cite{Koesner, C, Nordhausen, K. and Virta, J. (2019), Estimating the signal tensor dimension using tensorial PCA. Manuscript.}
}
\keyword{ package }
\keyword{multivariate}
\keyword{ts}
\keyword{array}


