% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miss_factor_est.R
\name{miss_factor_est}
\alias{miss_factor_est}
\title{Estimation of tensor factor models with missing data}
\usage{
miss_factor_est(dt, r = 0, delta = 0.2)
}
\arguments{
\item{dt}{Tensor time series, written in an array with dimension K+1 and mode-1 as the time mode.}

\item{r}{Rank of core tensors, written in a vector of length K. First value as 0 is to denote unknown rank which would be automatically estimated using ratio-based estimators. Default is 0.}

\item{delta}{Non-negative number as the correction parameter for rank estimation. Default is 0.2.}
}
\value{
A list containing the following:
r: a vector representing either the given rank or the estimated rank, with length K;
A: a list of estimated K factor loading matrices;
Ft: the estimated core factor series, as multi-dimensional array with dimension K+1, where mode-1 is the time mode;
imputation: the imputed common component time series, as multi-dimensional array with dimension K+1, where mode-1 is the time mode;
covMatrix: a list of estimated covariance matrix which are used to estimate loading matrices;
}
\description{
Estimate the factor structure on an order-K tensor at each time t, with maximum K as 3 and missing entries allowed
}
\examples{
K = 3;
TT = 10;
d = c(20,20,20);
r = c(2,2,2);
re = c(2,2,2);
eta = list(c(0,0), c(0,0), c(0,0));
coef_f = c(0.7, 0.3, -0.4, 0.2, -0.1);
coef_fe = c(-0.7, -0.3, -0.4, 0.2, 0.1);
coef_e = c(0.8, 0.4, -0.4, 0.2, -0.1);
data_test = tensor_gen(K,TT,d,r,re,eta, coef_f, coef_fe, coef_e);
data_miss = miss_gen(data_test$X);
miss_factor_est(data_miss, r);



}
