% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eager.R
\name{tfe_enable_eager_execution}
\alias{tfe_enable_eager_execution}
\title{Enables, for the rest of the lifetime of this program, eager execution.}
\usage{
tfe_enable_eager_execution(config = NULL, device_policy = c("explicit",
  "warn", "silent"))
}
\arguments{
\item{config}{(Optional) A \code{tf$ConfigProto()} protocol buffer with
configuration options for the Context. Note that a lot of these options
may be currently unimplemented or irrelevant when eager execution is
enabled.}

\item{device_policy}{(Optional) What policy to use when trying to run an
operation on a device with inputs which are not on that device. Valid
values: "explicit": raises an error if the placement is not correct.
"warn": copies the tensors which are not on the right device but raises a
warning. "silent": silently copies the tensors. This might hide
performance problems.}
}
\description{
If not called immediately on startup risks creating breakage and bugs.
}
\details{
After eager execution is enabled, operations are executed as they are
defined and tensors hold concrete values, and can be accessed as R matrices
or arrays with \code{\link[=as.matrix]{as.matrix()}}, \code{\link[=as.array]{as.array()}}, \code{\link[=as.double]{as.double()}}, etc.
}
\examples{
\dontrun{

# load tensorflow and enable eager execution
library(tensorflow)
tfe_enable_eager_execution()

# create a random 10x10 matrix
x <- tf$random_normal(shape(10, 10))

# use it in R via as.matrix()
heatmap(as.matrix(x))
}

}
